"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.osVersionTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _stats_list = require("./stats_list");
var _use_mobile_statistics_fetcher = require("./use_mobile_statistics_fetcher");
var _apm = require("../../../../../../common/es_fields/apm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/transaction_overview/transaction_overview_tabs/os_version_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OSVersionTab({
  environment,
  kuery,
  start,
  end,
  comparisonEnabled,
  offset
}) {
  const {
    mainStatistics,
    mainStatisticsStatus,
    detailedStatistics,
    detailedStatisticsStatus
  } = (0, _use_mobile_statistics_fetcher.useMobileStatisticsFetcher)({
    field: _apm.HOST_OS_VERSION,
    environment,
    kuery,
    start,
    end,
    comparisonEnabled,
    offset
  });
  return /*#__PURE__*/_react.default.createElement(_stats_list.StatsList, {
    isLoading: (0, _use_fetcher.isPending)(mainStatisticsStatus),
    mainStatistics: mainStatistics,
    detailedStatisticsLoading: (0, _use_fetcher.isPending)(detailedStatisticsStatus),
    detailedStatistics: detailedStatistics,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
}
const osVersionTab = exports.osVersionTab = {
  dataTestSubj: 'apmOsVersionTab',
  key: 'os_version_tab',
  label: _i18n.i18n.translate('xpack.apm.mobile.transactions.overview.tabs.os.version', {
    defaultMessage: 'OS version'
  }),
  component: OSVersionTab
};