"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraTabs = InfraTabs;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _empty_prompt = require("./empty_prompt");
var _failure_prompt = require("./failure_prompt");
var _use_tabs = require("./use_tabs");
var _url_helpers = require("../../../shared/links/url_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/infra_overview/infra_tabs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_STATE = {
  containerIds: [],
  hostNames: [],
  podNames: []
};
function InfraTabs() {
  var _tabs$find;
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      detailTab
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/infrastructure');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/infrastructure_attributes', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end]);
  const {
    containerIds,
    podNames,
    hostNames
  } = data;
  const tabs = (0, _use_tabs.useTabs)({
    containerIds,
    podNames,
    hostNames,
    start,
    end
  });
  if (status === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }));
  }
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_failure_prompt.FailurePrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }));
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS && !containerIds.length && !podNames.length && !hostNames.length) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }));
  }
  const currentTab = (_tabs$find = tabs.find(({
    id
  }) => id === detailTab)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, tabs.map(({
    id,
    name
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        (0, _url_helpers.push)(history, {
          query: {
            detailTab: id
          }
        });
      },
      isSelected: currentTab.id === id,
      id: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, name);
  })), currentTab.content);
}