"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _aiopsComponents = require("@kbn/aiops-components");
var _client = require("@kbn/ml-response-stream/client");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/aiops-common/constants");
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
var _log_rate_analysis_field_candidates_slice = require("@kbn/aiops-log-rate-analysis/state/log_rate_analysis_field_candidates_slice");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _log_rate_analysis_results_table = require("../log_rate_analysis_results_table");
var _log_rate_analysis_info_popover = require("./log_rate_analysis_info_popover");
var _log_rate_analysis_options = require("./log_rate_analysis_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const groupResultsHelpMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsHelpMessage', {
  defaultMessage: 'Items which are unique to a group are marked by an asterisk (*).'
});

/**
 * Interface for log rate analysis results data.
 */

/**
 * LogRateAnalysis props require a data view.
 */

const LogRateAnalysisResults = ({
  onReset,
  searchQuery,
  barColorOverride,
  barHighlightColorOverride
}) => {
  var _data$loadingState;
  const {
    analytics,
    http,
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const dispatch = (0, _state.useAppDispatch)();
  const {
    analysisType,
    earliest,
    latest,
    chartWindowParameters,
    documentStats: {
      sampleProbability
    },
    stickyHistogram,
    isBrushCleared,
    groupResults
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    isRunning,
    errors: streamErrors
  } = (0, _state.useAppSelector)(s => s.stream);
  const data = (0, _state.useAppSelector)(s => s.logRateAnalysisResults);
  const fieldCandidates = (0, _state.useAppSelector)(s => s.logRateAnalysisFieldCandidates);
  const {
    skippedColumns
  } = (0, _state.useAppSelector)(s => s.logRateAnalysisTable);
  const {
    currentAnalysisWindowParameters
  } = data;

  // Store the performance metric's start time using a ref
  // to be able to track it across rerenders.
  const analysisStartTime = (0, _react.useRef)(window.performance.now());
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const previousSearchQuery = (0, _react.useRef)(searchQuery);
  const [overrides, setOverrides] = (0, _react.useState)(undefined);
  const [shouldStart, setShouldStart] = (0, _react.useState)(false);
  const [embeddableOptionsVisible, setEmbeddableOptionsVisible] = (0, _react.useState)(false);
  const onEmbeddableOptionsClickHandler = () => {
    setEmbeddableOptionsVisible(s => !s);
  };
  const {
    currentFieldFilterSkippedItems,
    keywordFieldCandidates,
    textFieldCandidates
  } = fieldCandidates;
  (0, _react.useEffect)(() => {
    if (currentFieldFilterSkippedItems === null) return;
    dispatch((0, _stream_reducer.resetResults)());
    setOverrides({
      loaded: 0,
      remainingKeywordFieldCandidates: keywordFieldCandidates.filter(d => !currentFieldFilterSkippedItems.includes(d)),
      remainingTextFieldCandidates: textFieldCandidates.filter(d => !currentFieldFilterSkippedItems.includes(d)),
      regroupOnly: false
    });
    startHandler(true, false);
    // custom check to trigger on currentFieldFilterSkippedItems change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentFieldFilterSkippedItems]);
  function cancelHandler() {
    abortCtrl.current.abort();
    dispatch((0, _client.cancelStream)());
  }
  (0, _react.useEffect)(() => {
    if (!isRunning) {
      const {
        loaded,
        remainingKeywordFieldCandidates,
        remainingTextFieldCandidates,
        groupsMissing
      } = data;
      if (loaded < 1 && (Array.isArray(remainingKeywordFieldCandidates) && remainingKeywordFieldCandidates.length > 0 || Array.isArray(remainingTextFieldCandidates) && remainingTextFieldCandidates.length > 0 || groupsMissing)) {
        setOverrides({
          loaded,
          remainingKeywordFieldCandidates,
          remainingTextFieldCandidates,
          significantItems: data.significantItems
        });
      } else if (loaded > 0) {
        // Reset all overrides.
        setOverrides(undefined);

        // Track performance metric
        if (analysisStartTime.current !== undefined) {
          const analysisDuration = window.performance.now() - analysisStartTime.current;

          // Set this to undefined so reporting the metric gets triggered only once.
          analysisStartTime.current = undefined;
          (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
            eventName: 'aiopsLogRateAnalysisCompleted',
            duration: analysisDuration
          });
        }
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isRunning]);
  const errors = (0, _react.useMemo)(() => [...streamErrors, ...data.errors], [streamErrors, data.errors]);

  // Start handler clears possibly hovered or pinned
  // significant items on analysis refresh.
  function startHandler(continueAnalysis = false, resetGroupButton = true) {
    if (!continueAnalysis) {
      dispatch((0, _stream_reducer.resetResults)());
      setOverrides({
        remainingKeywordFieldCandidates: keywordFieldCandidates.filter(d => currentFieldFilterSkippedItems === null || !currentFieldFilterSkippedItems.includes(d)),
        remainingTextFieldCandidates: textFieldCandidates.filter(d => currentFieldFilterSkippedItems === null || !currentFieldFilterSkippedItems.includes(d))
      });
    }

    // Reset grouping to false and clear all row selections when restarting the analysis.
    if (resetGroupButton) {
      dispatch((0, _state.setGroupResults)(false));
      // When toggling the group switch, clear all row selections
      dispatch((0, _state.clearAllRowState)());
    }
    dispatch((0, _stream_reducer.setCurrentAnalysisType)(analysisType));
    dispatch((0, _stream_reducer.setCurrentAnalysisWindowParameters)(chartWindowParameters));

    // We trigger hooks updates above so we cannot directly call `start()` here
    // because it would be run with stale arguments.
    setShouldStart(true);
  }
  const startParams = (0, _react.useMemo)(() => {
    var _dataView$timeFieldNa;
    if (!chartWindowParameters || !earliest || !latest) {
      return undefined;
    }
    return {
      http,
      endpoint: '/internal/aiops/log_rate_analysis',
      apiVersion: '3',
      abortCtrl,
      body: {
        start: earliest,
        end: latest,
        searchQuery: JSON.stringify(searchQuery),
        // TODO Handle data view without time fields.
        timeFieldName: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : '',
        index: dataView.getIndexPattern(),
        // Temporarily disable grouping until https://github.com/elastic/kibana/issues/232849 is resolved.
        grouping: false,
        flushFix: true,
        // If analysis type is `spike`, pass on window parameters as is,
        // if it's `dip`, swap baseline and deviation.
        ...(analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE ? chartWindowParameters : (0, _aiopsLogRateAnalysis.getSwappedWindowParameters)(chartWindowParameters)),
        overrides,
        sampleProbability
      },
      headers: {
        [_constants.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
      }
    };
  }, [analysisType, earliest, latest, http, searchQuery, dataView, chartWindowParameters, sampleProbability, overrides, embeddingOrigin]);
  (0, _react.useEffect)(() => {
    if (shouldStart && startParams) {
      dispatch((0, _client.startStream)(startParams));
      setShouldStart(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [shouldStart]);

  // On mount, fetch field candidates first. Once they are populated,
  // the actual analysis will be triggered.
  (0, _react.useEffect)(() => {
    if (startParams) {
      dispatch((0, _log_rate_analysis_field_candidates_slice.fetchFieldCandidates)(startParams));
      dispatch((0, _stream_reducer.setCurrentAnalysisType)(analysisType));
      dispatch((0, _stream_reducer.setCurrentAnalysisWindowParameters)(chartWindowParameters));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const groupTableItems = (0, _react.useMemo)(() => (0, _log_rate_analysis_results_table.getGroupTableItems)(data.significantItemsGroups), [data.significantItemsGroups]);
  const searchQueryUpdated = (0, _react.useMemo)(() => {
    let searchQueryChanged = false;
    if (!isRunning && previousSearchQuery.current !== undefined && !(0, _lodash.isEqual)(previousSearchQuery.current, searchQuery)) {
      searchQueryChanged = true;
    }
    previousSearchQuery.current = searchQuery;
    return searchQueryChanged;
  }, [searchQuery, isRunning]);
  const shouldRerunAnalysis = (0, _react.useMemo)(() => currentAnalysisWindowParameters !== undefined && !(0, _lodash.isEqual)(currentAnalysisWindowParameters, chartWindowParameters), [currentAnalysisWindowParameters, chartWindowParameters]);
  const showLogRateAnalysisResultsTable = (data === null || data === void 0 ? void 0 : data.significantItems.length) > 0;
  const groupItemCount = groupTableItems.reduce((p, c) => {
    return p + c.groupItemsSortedByUniqueness.length;
  }, 0);
  const foundGroups = groupTableItems.length > 0 && groupItemCount > 0;
  const isAnalysisControlsDisabled = embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.CASES;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiopsLogRateAnalysisResults",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_aiopsComponents.ProgressControls, {
    isBrushCleared: isBrushCleared,
    progress: data.loaded,
    progressMessage: (_data$loadingState = data.loadingState) !== null && _data$loadingState !== void 0 ? _data$loadingState : '',
    isRunning: isRunning,
    onRefresh: () => startHandler(false),
    onCancel: cancelHandler,
    onReset: onReset,
    shouldRerunAnalysis: shouldRerunAnalysis || searchQueryUpdated,
    analysisInfo: /*#__PURE__*/_react.default.createElement(_log_rate_analysis_info_popover.LogRateAnalysisInfoPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 23
      }
    }),
    isAnalysisControlsDisabled: isAnalysisControlsDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, embeddingOrigin !== _constants.AIOPS_EMBEDDABLE_ORIGIN.DASHBOARD && /*#__PURE__*/_react.default.createElement(_log_rate_analysis_options.LogRateAnalysisOptions, {
    foundGroups: foundGroups,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 13
    }
  }), embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.DASHBOARD && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.optionsButtonTooltip', {
      defaultMessage: 'Options to customize the analysis, such as filtering fields.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "aiopsLogRateAnalysisOptionsButton",
    iconType: "controlsHorizontal",
    onClick: onEmbeddableOptionsClickHandler,
    "aria-label": _i18n.i18n.translate('xpack.aiops.logRateAnalysis.optionsButtonAriaLabel', {
      defaultMessage: 'Analysis options'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 17
    }
  }))))), embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.DASHBOARD && embeddableOptionsVisible && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_options.LogRateAnalysisOptions, {
    foundGroups: foundGroups,
    growFirstItem: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 13
    }
  }))), errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.aiops.analysis.errorCallOutTitle', {
      defaultMessage: 'The following {errorCount, plural, one {error} other {errors}} occurred running the analysis.',
      values: {
        errorCount: errors.length
      }
    }),
    color: "warning",
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 13
    }
  }, errors.length === 1 ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 17
    }
  }, errors[0]) : /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 17
    }
  }, errors.map((e, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 21
    }
  }, e))), overrides !== undefined ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "aiopsLogRateAnalysisResultsTryToContinueAnalysisButton",
    size: "s",
    onClick: () => startHandler(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.tryToContinueAnalysisButtonText",
    defaultMessage: "Try to continue analysis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 21
    }
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 11
    }
  })) : null, showLogRateAnalysisResultsTable && groupResults && foundGroups && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 11
    }
  }, groupResults ? groupResultsHelpMessage : undefined)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 7
    }
  }), !isRunning && !showLogRateAnalysisResultsTable && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "aiopsNoResultsFoundEmptyPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noResultsPromptTitle",
      defaultMessage: "The analysis did not return any results.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 442,
        columnNumber: 15
      }
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noResultsPromptBody",
      defaultMessage: "Try to adjust the baseline and deviation time ranges and rerun the analysis. If you still get no results, there might be no statistically significant entities contributing to this deviation in log rate.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: stickyHistogram ? {
      height: '500px',
      overflowX: 'hidden',
      overflowY: 'auto',
      paddingTop: '20px'
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 7
    }
  }, showLogRateAnalysisResultsTable && groupResults ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsGroupsTable, {
    skippedColumns: skippedColumns,
    significantItems: data.significantItems,
    groupTableItems: groupTableItems,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 11
    }
  }) : null, showLogRateAnalysisResultsTable && !groupResults ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsTable, {
    skippedColumns: skippedColumns,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 483,
      columnNumber: 11
    }
  }) : null));
};
exports.LogRateAnalysisResults = LogRateAnalysisResults;