"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisInfoPopoverButton = exports.LogRateAnalysisInfoPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_info_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogRateAnalysisInfoPopoverButton = ({
  onClick,
  label
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "question",
    iconSide: "right",
    color: "hollow"
    // Defining both iconOnClick and onClick so the mouse cursor changes for cases.
    ,
    iconOnClick: onClick,
    iconOnClickAriaLabel: "Click to open \"Log rate analysis info\" popover",
    onClick: onClick,
    onClickAriaLabel: "Click to open \"Log rate analysis info\" popover",
    "data-test-subj": "aiopsLogRateAnalysisInfoPopoverButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, label);
};
exports.LogRateAnalysisInfoPopoverButton = LogRateAnalysisInfoPopoverButton;
const LogRateAnalysisInfoPopover = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const showInfoPopover = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.significantItems.length > 0);
  const zeroDocsFallback = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.zeroDocsFallback);
  const analysisType = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.currentAnalysisType);
  const fieldSelectionMessage = (0, _state.useAppSelector)(s => s.logRateAnalysisFieldCandidates.fieldSelectionMessage);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const popoverTitleId = (0, _eui.htmlIdGenerator)()('logRateAnalysisInfoPopoverTitle');
  const infoTitlePrefix = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeInfoTitlePrefix', {
    defaultMessage: 'Analysis type: '
  });
  let infoTitle;
  let infoContent;
  if (!showInfoPopover) {
    return null;
  }
  if (!zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE) {
    infoTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeInfoTitle', {
      defaultMessage: 'Log rate spike'
    });
    infoContent = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeInfoContent', {
      defaultMessage: 'The median log rate in the selected deviation time range is higher than the baseline. Therefore, the analysis results table shows statistically significant items within the deviation time range that are contributors to the spike. The "doc count" column refers to the amount of documents in the deviation time range.'
    });
  } else if (!zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP) {
    infoTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipInfoTitle', {
      defaultMessage: 'Log rate dip'
    });
    infoContent = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipInfoContent', {
      defaultMessage: 'The median log rate in the selected deviation time range is lower than the baseline. Therefore, the analysis results table shows statistically significant items within the baseline time range that are less in number or missing within the deviation time range. The "doc count" column refers to the amount of documents in the baseline time range.'
    });
  } else if (zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE) {
    infoTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeFallbackInfoTitle', {
      defaultMessage: 'Top items for deviation time range'
    });
    infoContent = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeInfoContentFallback', {
      defaultMessage: 'The baseline time range does not contain any documents. Therefore the results show top log message categories and field values for the deviation time range.'
    });
  } else if (zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP) {
    infoTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipFallbackInfoTitle', {
      defaultMessage: 'Top items for baseline time range'
    });
    infoContent = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipInfoContentFallback', {
      defaultMessage: 'The deviation time range does not contain any documents. Therefore the results show top log message categories and field values for the baseline time range.'
    });
  } else {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "upCenter",
    button: /*#__PURE__*/_react.default.createElement(LogRateAnalysisInfoPopoverButton, {
      onClick: setIsPopoverOpen.bind(null, !isPopoverOpen),
      label: infoTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }),
    closePopover: setIsPopoverOpen.bind(null, false),
    isOpen: isPopoverOpen,
    ownFocus: true,
    panelPaddingSize: "m",
    "aria-labelledby": popoverTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, infoTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    id: popoverTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, infoTitlePrefix, infoTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: {
      maxWidth: `calc(${euiTheme.size.xl} * 15);`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, infoContent, fieldSelectionMessage && ` ${fieldSelectionMessage}`)));
};
exports.LogRateAnalysisInfoPopover = LogRateAnalysisInfoPopover;