"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _field_stats = require("@kbn/unified-field-list/src/components/field_stats");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/field_stats_popover/field_stats_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_COLOR = (0, _eui.euiPaletteColorBlind)()[0];
const HIGHLIGHTED_FIELD_PROPS = {
  color: 'accent',
  textProps: {
    color: 'accent'
  }
};
function getPercentValue(currentValue, totalCount, digitsRequired) {
  const percentageString = totalCount > 0 ? `${(Math.round(currentValue / totalCount * 1000) / 10).toFixed(digitsRequired ? 1 : 0)}` : '';
  return Number(percentageString);
}
const FieldStatsContent = ({
  dataView: currentDataView,
  field,
  fieldName,
  fieldValue,
  fieldStatsServices,
  timeRangeMs,
  dslQuery
}) => {
  const [fieldStatsState, setFieldStatsState] = (0, _react.useState)();

  // Format timestamp to ISO formatted date strings
  const timeRange = (0, _react.useMemo)(() => {
    // Use the provided timeRange if available
    if (timeRangeMs) {
      return {
        from: (0, _moment.default)(timeRangeMs.from).toISOString(),
        to: (0, _moment.default)(timeRangeMs.to).toISOString()
      };
    }
    const now = (0, _moment.default)();
    return {
      from: now.toISOString(),
      to: now.toISOString()
    };
  }, [timeRangeMs]);
  const onStateChange = (0, _react.useCallback)(nextState => {
    setFieldStatsState(nextState);
  }, []);
  const individualStatForDisplay = (0, _react.useMemo)(() => {
    const defaultIndividualStatForDisplay = {
      needToDisplayIndividualStat: false,
      percentage: '< 1%'
    };
    if (fieldStatsState === undefined) return defaultIndividualStatForDisplay;
    const {
      topValues: currentTopValues,
      sampledValues
    } = fieldStatsState;
    const idxToHighlight = currentTopValues !== null && currentTopValues !== void 0 && currentTopValues.buckets && Array.isArray(currentTopValues.buckets) ? currentTopValues.buckets.findIndex(value => value.key === fieldValue) : null;
    const needToDisplayIndividualStat = idxToHighlight === -1 && fieldName !== undefined && fieldValue !== undefined;
    if (needToDisplayIndividualStat) {
      var _lowestPercentage;
      defaultIndividualStatForDisplay.needToDisplayIndividualStat = true;
      const buckets = currentTopValues !== null && currentTopValues !== void 0 && currentTopValues.buckets && Array.isArray(currentTopValues.buckets) ? currentTopValues.buckets : [];
      let lowestPercentage;

      // Taken from the unifiedFieldList plugin
      const digitsRequired = buckets.some(bucket => !Number.isInteger(bucket.count / (sampledValues !== null && sampledValues !== void 0 ? sampledValues : 5000)));
      buckets.forEach(bucket => {
        const currentPercentage = getPercentValue(bucket.count, sampledValues !== null && sampledValues !== void 0 ? sampledValues : 5000, digitsRequired);
        if (lowestPercentage === undefined || currentPercentage < lowestPercentage) {
          lowestPercentage = currentPercentage;
        }
      });
      defaultIndividualStatForDisplay.percentage = `< ${(_lowestPercentage = lowestPercentage) !== null && _lowestPercentage !== void 0 ? _lowestPercentage : 1}%`;
    }
    return defaultIndividualStatForDisplay;
  }, [fieldStatsState, fieldName, fieldValue]);
  const overrideFieldTopValueBar = (0, _react.useCallback)(fieldTopValuesBucketParams => {
    if (fieldTopValuesBucketParams.type === 'other') {
      return {
        color: 'primary'
      };
    }
    return fieldValue === fieldTopValuesBucketParams.fieldValue ? HIGHLIGHTED_FIELD_PROPS : {};
  }, [fieldValue]);
  const showFieldStats = timeRange && (0, _mlIsDefined.isDefined)(currentDataView) && field;
  if (!showFieldStats) return null;
  const formatter = currentDataView.getFormatterForField(field);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_stats.FieldStats, {
    key: field.name,
    services: fieldStatsServices,
    dslQuery: dslQuery !== null && dslQuery !== void 0 ? dslQuery : {
      match_all: {}
    },
    fromDate: timeRange.from,
    toDate: timeRange.to,
    dataViewOrDataViewId: currentDataView,
    field: field,
    "data-test-subj": `mlAiOpsFieldStatsPopoverContent ${field.name}`,
    color: DEFAULT_COLOR,
    onStateChange: onStateChange,
    overrideFieldTopValueBar: overrideFieldTopValueBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }), individualStatForDisplay.needToDisplayIndividualStat ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.fieldContextPopover.notTopTenValueMessage",
    defaultMessage: "Selected term is not in the top 10",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_field_stats.FieldTopValuesBucket, (0, _extends2.default)({
    field: field,
    fieldValue: fieldValue,
    formattedPercentage: individualStatForDisplay.percentage,
    formattedFieldValue: formatter.convert(fieldValue)
    // Always set as completed since calc is done once we're here
    ,
    progressValue: 100,
    count: 0,
    overrideFieldTopValueBar: overrideFieldTopValueBar,
    'data-test-subj': 'aiopsNotInTopTenFieldTopValueBucket'
  }, HIGHLIGHTED_FIELD_PROPS, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }))) : null);
};
exports.FieldStatsContent = FieldStatsContent;