"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBindingActivations = resolveBindingActivations;
const common_1 = require("@inversifyjs/common");
const resolveBindingServiceActivations_1 = require("./resolveBindingServiceActivations");
function resolveBindingActivations(params, binding, value) {
    let activationResult = value;
    if (binding.onActivation !== undefined) {
        const onActivation = binding.onActivation;
        if ((0, common_1.isPromise)(activationResult)) {
            activationResult = activationResult.then((resolved) => onActivation(params.context, resolved));
        }
        else {
            activationResult = onActivation(params.context, activationResult);
        }
    }
    return (0, resolveBindingServiceActivations_1.resolveBindingServiceActivations)(params, binding.serviceIdentifier, activationResult);
}
//# sourceMappingURL=resolveBindingActivations.js.map