/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class LossySumDoubleAggregator {
    LossySumDoubleAggregator() {
    }

    public static SumState initSingle() {
        return new SumState();
    }

    public static void combine(SumState current, double v) {
        current.value += v;
    }

    public static void combine(SumState current, double value, double unusedDelta) {
        assert (unusedDelta == 0.0) : "Lossy sum should not have delta " + unusedDelta;
        current.value += value;
    }

    public static void combineIntermediate(SumState state, double inValue, double unusedDelta, boolean seen) {
        assert (unusedDelta == 0.0) : "Lossy sum should not have delta " + unusedDelta;
        if (seen) {
            LossySumDoubleAggregator.combine(state, inValue);
            state.seen(true);
        }
    }

    public static void evaluateIntermediate(SumState state, DriverContext driverContext, Block[] blocks, int offset) {
        assert (blocks.length >= offset + 3);
        BlockFactory blockFactory = driverContext.blockFactory();
        blocks[offset + 0] = blockFactory.newConstantDoubleBlockWith(state.value, 1);
        blocks[offset + 1] = blockFactory.newConstantDoubleBlockWith(0.0, 1);
        blocks[offset + 2] = blockFactory.newConstantBooleanBlockWith(state.seen(), 1);
    }

    public static Block evaluateFinal(SumState state, DriverContext driverContext) {
        return driverContext.blockFactory().newConstantDoubleBlockWith(state.value, 1);
    }

    public static GroupingSumState initGrouping(BigArrays bigArrays) {
        return new GroupingSumState(bigArrays);
    }

    public static void combine(GroupingSumState current, int groupId, double v) {
        current.add(v, groupId);
    }

    public static void combineIntermediate(GroupingSumState current, int groupId, double value, double zeroDelta, boolean seen) {
        assert (zeroDelta == 0.0) : zeroDelta;
        if (seen) {
            current.add(value, groupId);
        }
    }

    public static void evaluateIntermediate(GroupingSumState state, Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        try (DoubleVector.FixedBuilder valuesBuilder = driverContext.blockFactory().newDoubleVectorFixedBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder seenBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < state.values.size()) {
                    valuesBuilder.appendDouble(state.values.get((long)group));
                } else {
                    valuesBuilder.appendDouble(0.0);
                }
                seenBuilder.appendBoolean(state.hasValue(group));
            }
            blocks[offset + 0] = valuesBuilder.build().asBlock();
            blocks[offset + 1] = driverContext.blockFactory().newConstantDoubleBlockWith(0.0, selected.getPositionCount());
            blocks[offset + 2] = seenBuilder.build().asBlock();
        }
    }

    public static Block evaluateFinal(GroupingSumState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        try (DoubleBlock.Builder builder = ctx.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int si = selected.getInt(i);
                if (state.hasValue(si) && (long)si < state.values.size()) {
                    builder.appendDouble(state.values.get((long)si));
                    continue;
                }
                builder.appendNull();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    public static GroupingAggregatorFunction.AddInput wrapAddInput(final GroupingAggregatorFunction.AddInput delegate, final GroupingSumState state, final DoubleVector values) {
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                delegate.add(positionOffset, groupIds);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                delegate.add(positionOffset, groupIds);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                if (groupIds.isConstant()) {
                    double sum = 0.0;
                    int to = positionOffset + groupIds.getPositionCount();
                    for (int i = positionOffset; i < to; ++i) {
                        sum += values.getDouble(i);
                    }
                    state.add(sum, groupIds.getInt(0));
                } else {
                    delegate.add(positionOffset, groupIds);
                }
            }

            public void close() {
                Releasables.close((Releasable)delegate);
            }
        };
    }

    static final class SumState
    implements AggregatorState {
        private boolean seen;
        double value;

        SumState() {
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            LossySumDoubleAggregator.evaluateIntermediate(this, driverContext, blocks, offset);
        }

        public void close() {
        }

        public boolean seen() {
            return this.seen;
        }

        public void seen(boolean seen) {
            this.seen = seen;
        }
    }

    static final class GroupingSumState
    extends AbstractArrayState
    implements GroupingAggregatorState {
        private DoubleArray values;

        GroupingSumState(BigArrays bigArrays) {
            super(bigArrays);
            boolean success = false;
            try {
                this.values = bigArrays.newDoubleArray(128L);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        void add(double valueToAdd, int groupId) {
            this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
            this.values.increment((long)groupId, valueToAdd);
            this.trackGroupId(groupId);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            LossySumDoubleAggregator.evaluateIntermediate(this, blocks, offset, selected, driverContext);
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
        }
    }
}

