/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.TransportSettings;

public class RemoteClusterSettings {
    public static final TimeValue DEFAULT_INITIAL_CONNECTION_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    public static final Setting<TimeValue> REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.remote.initial_connect_timeout", DEFAULT_INITIAL_CONNECTION_TIMEOUT, Setting.Property.NodeScope);
    public static final Setting<String> REMOTE_NODE_ATTRIBUTE = Setting.simpleString("cluster.remote.node.attr", Setting.Property.NodeScope);
    public static final boolean DEFAULT_SKIP_UNAVAILABLE = true;
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("cluster.remote.", "skip_unavailable", (ns, key) -> Setting.boolSetting(key, true, new RemoteConnectionEnabled<Boolean>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> REMOTE_CLUSTER_PING_SCHEDULE = Setting.affixKeySetting("cluster.remote.", "transport.ping_schedule", (ns, key) -> Setting.timeSetting(key, TransportSettings.PING_SCHEDULE, new RemoteConnectionEnabled<TimeValue>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Compression.Enabled> REMOTE_CLUSTER_COMPRESS = Setting.affixKeySetting("cluster.remote.", "transport.compress", (ns, key) -> Setting.enumSetting(Compression.Enabled.class, key, TransportSettings.TRANSPORT_COMPRESS, new RemoteConnectionEnabled((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Compression.Scheme> REMOTE_CLUSTER_COMPRESSION_SCHEME = Setting.affixKeySetting("cluster.remote.", "transport.compression_scheme", (ns, key) -> Setting.enumSetting(Compression.Scheme.class, key, TransportSettings.TRANSPORT_COMPRESSION_SCHEME, new RemoteConnectionEnabled((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> REMOTE_CLUSTER_CREDENTIALS = Setting.affixKeySetting("cluster.remote.", "credentials", key -> SecureSetting.secureString(key, null, new Setting.Property[0]), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<RemoteConnectionStrategy.ConnectionStrategy> REMOTE_CONNECTION_MODE = Setting.affixKeySetting("cluster.remote.", "mode", key -> new Setting<RemoteConnectionStrategy.ConnectionStrategy>((String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF.name(), value -> RemoteConnectionStrategy.ConnectionStrategy.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope, Setting.Property.Dynamic), new Setting.AffixSettingDependency[0]);
    public static final int DEFAULT_MAX_PENDING_CONNECTION_LISTENERS = 1000;
    public static final Setting<Integer> REMOTE_MAX_PENDING_CONNECTION_LISTENERS = Setting.intSetting("cluster.remote.max_pending_connection_listeners", 1000, Setting.Property.NodeScope);

    public static Set<String> getRemoteClusters(Settings settings) {
        return Arrays.stream(RemoteConnectionStrategy.ConnectionStrategy.values()).flatMap(RemoteClusterSettings::getEnablementSettings).flatMap(s -> RemoteClusterSettings.getClusterAlias(settings, s)).collect(Collectors.toSet());
    }

    private static <T> Stream<String> getClusterAlias(Settings settings, Setting.AffixSetting<T> affixSetting) {
        Stream<Setting<Setting>> allConcreteSettings = affixSetting.getAllConcreteSettings(settings);
        return allConcreteSettings.map(affixSetting::getNamespace);
    }

    private static Stream<Setting.AffixSetting<?>> getEnablementSettings(RemoteConnectionStrategy.ConnectionStrategy strategy) {
        return switch (strategy) {
            default -> throw new MatchException(null, null);
            case RemoteConnectionStrategy.ConnectionStrategy.SNIFF -> SniffConnectionStrategySettings.enablementSettings();
            case RemoteConnectionStrategy.ConnectionStrategy.PROXY -> ProxyConnectionStrategySettings.enablementSettings();
        };
    }

    static LinkedProjectConfig toConfig(String clusterAlias, Settings settings) {
        return RemoteClusterSettings.toConfig(ProjectId.DEFAULT, ProjectId.DEFAULT, clusterAlias, settings);
    }

    public static LinkedProjectConfig toConfig(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias, Settings settings) {
        if ("".equals(linkedProjectAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        RemoteConnectionStrategy.ConnectionStrategy strategy = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(linkedProjectAlias).get(settings);
        LinkedProjectConfig.Builder builder = switch (strategy) {
            default -> throw new MatchException(null, null);
            case RemoteConnectionStrategy.ConnectionStrategy.SNIFF -> SniffConnectionStrategySettings.readSettings(linkedProjectAlias, settings, new LinkedProjectConfig.SniffLinkedProjectConfigBuilder(originProjectId, linkedProjectId, linkedProjectAlias));
            case RemoteConnectionStrategy.ConnectionStrategy.PROXY -> ProxyConnectionStrategySettings.readSettings(linkedProjectAlias, settings, new LinkedProjectConfig.ProxyLinkedProjectConfigBuilder(originProjectId, linkedProjectId, linkedProjectAlias));
        };
        RemoteClusterSettings.readConnectionSettings(linkedProjectAlias, settings, builder);
        return builder.build();
    }

    private static void readConnectionSettings(String clusterAlias, Settings settings, LinkedProjectConfig.Builder<?> builder) {
        ((LinkedProjectConfig.Builder)((LinkedProjectConfig.Builder)((LinkedProjectConfig.Builder)((LinkedProjectConfig.Builder)((LinkedProjectConfig.Builder)((LinkedProjectConfig.Builder)builder.transportConnectTimeout(TransportSettings.CONNECT_TIMEOUT.get(settings))).connectionCompression(REMOTE_CLUSTER_COMPRESS.getConcreteSettingForNamespace(clusterAlias).get(settings))).connectionCompressionScheme(REMOTE_CLUSTER_COMPRESSION_SCHEME.getConcreteSettingForNamespace(clusterAlias).get(settings))).clusterPingSchedule(REMOTE_CLUSTER_PING_SCHEDULE.getConcreteSettingForNamespace(clusterAlias).get(settings))).initialConnectionTimeout(REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.get(settings))).maxPendingConnectionListeners(REMOTE_MAX_PENDING_CONNECTION_LISTENERS.get(settings))).skipUnavailable(REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSettingForNamespace(clusterAlias).get(settings));
    }

    public static boolean isConnectionEnabled(String clusterAlias, Settings settings) {
        RemoteConnectionStrategy.ConnectionStrategy mode = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case RemoteConnectionStrategy.ConnectionStrategy.SNIFF -> {
                if (!SniffConnectionStrategySettings.REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias).get(settings).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case RemoteConnectionStrategy.ConnectionStrategy.PROXY -> !ProxyConnectionStrategySettings.PROXY_ADDRESS.getConcreteSettingForNamespace(clusterAlias).get(settings).isEmpty();
        };
    }

    public static class SniffConnectionStrategySettings {
        public static final List<String> DEFAULT_SEED_NODES = Collections.emptyList();
        public static final Setting.AffixSetting<List<String>> REMOTE_CLUSTER_SEEDS = Setting.affixKeySetting("cluster.remote.", "seeds", (ns, key) -> Setting.listSetting(key, DEFAULT_SEED_NODES, s -> {
            RemoteConnectionStrategy.parsePort(s);
            return s;
        }, new StrategyValidator((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        public static final Setting.AffixSetting<String> REMOTE_CLUSTERS_PROXY = Setting.affixKeySetting("cluster.remote.", "proxy", (ns, key) -> Setting.simpleString(key, new StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF, s -> {
            if (Strings.hasLength(s)) {
                RemoteConnectionStrategy.parsePort(s);
            }
        }), Setting.Property.Dynamic, Setting.Property.NodeScope), () -> REMOTE_CLUSTER_SEEDS);
        public static final int DEFAULT_REMOTE_CONNECTIONS_PER_CLUSTER = 3;
        public static final Setting<Integer> REMOTE_CONNECTIONS_PER_CLUSTER = Setting.intSetting("cluster.remote.connections_per_cluster", 3, 1, Setting.Property.NodeScope);
        public static final Setting.AffixSetting<Integer> REMOTE_NODE_CONNECTIONS = Setting.affixKeySetting("cluster.remote.", "node_connections", (ns, key) -> Setting.intSetting(key, REMOTE_CONNECTIONS_PER_CLUSTER, 1, new StrategyValidator<Integer>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        public static final Predicate<DiscoveryNode> DEFAULT_NODE_PREDICATE = node -> Version.CURRENT.isCompatible(node.getVersion()) && (!node.isMasterNode() || node.canContainData() || node.isIngestNode());

        static Stream<Setting.AffixSetting<?>> enablementSettings() {
            return Stream.of(REMOTE_CLUSTER_SEEDS);
        }

        static LinkedProjectConfig.SniffLinkedProjectConfigBuilder readSettings(String clusterAlias, Settings settings, LinkedProjectConfig.SniffLinkedProjectConfigBuilder builder) {
            return (LinkedProjectConfig.SniffLinkedProjectConfigBuilder)((LinkedProjectConfig.SniffLinkedProjectConfigBuilder)builder.nodePredicate(SniffConnectionStrategySettings.getNodePredicate(settings)).seedNodes(REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias).get(settings)).proxyAddress(REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(clusterAlias).get(settings))).maxNumConnections(REMOTE_NODE_CONNECTIONS.getConcreteSettingForNamespace(clusterAlias).get(settings));
        }

        static Predicate<DiscoveryNode> getNodePredicate(Settings settings) {
            if (REMOTE_NODE_ATTRIBUTE.exists(settings)) {
                String attribute = REMOTE_NODE_ATTRIBUTE.get(settings);
                return DEFAULT_NODE_PREDICATE.and(node -> Booleans.parseBoolean((String)node.getAttributes().getOrDefault(attribute, "false")));
            }
            return DEFAULT_NODE_PREDICATE;
        }
    }

    public static class ProxyConnectionStrategySettings {
        public static final Setting.AffixSetting<String> PROXY_ADDRESS = Setting.affixKeySetting("cluster.remote.", "proxy_address", (ns, key) -> Setting.simpleString(key, new StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.PROXY, s -> {
            if (Strings.hasLength(s)) {
                RemoteConnectionStrategy.parsePort(s);
            }
        }), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        public static final int DEFAULT_REMOTE_SOCKET_CONNECTIONS = 18;
        public static final Setting.AffixSetting<Integer> REMOTE_SOCKET_CONNECTIONS = Setting.affixKeySetting("cluster.remote.", "proxy_socket_connections", (ns, key) -> Setting.intSetting(key, 18, 1, new StrategyValidator<Integer>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.PROXY), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        public static final Setting.AffixSetting<String> SERVER_NAME = Setting.affixKeySetting("cluster.remote.", "server_name", (ns, key) -> Setting.simpleString(key, new StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.PROXY), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);

        static Stream<Setting.AffixSetting<?>> enablementSettings() {
            return Stream.of(PROXY_ADDRESS);
        }

        static LinkedProjectConfig.ProxyLinkedProjectConfigBuilder readSettings(String clusterAlias, Settings settings, LinkedProjectConfig.ProxyLinkedProjectConfigBuilder builder) {
            return ((LinkedProjectConfig.ProxyLinkedProjectConfigBuilder)((LinkedProjectConfig.ProxyLinkedProjectConfigBuilder)builder.proxyAddress(PROXY_ADDRESS.getConcreteSettingForNamespace(clusterAlias).get(settings))).maxNumConnections(REMOTE_SOCKET_CONNECTIONS.getConcreteSettingForNamespace(clusterAlias).get(settings))).serverName(SERVER_NAME.getConcreteSettingForNamespace(clusterAlias).get(settings));
        }
    }

    private static class RemoteConnectionEnabled<T>
    implements Setting.Validator<T> {
        private final String clusterAlias;
        private final String key;

        private RemoteConnectionEnabled(String clusterAlias, String key) {
            this.clusterAlias = clusterAlias;
            this.key = key;
        }

        @Override
        public void validate(T value) {
        }

        @Override
        public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
            if (isPresent && !RemoteConnectionEnabled.isConnectionEnabled(this.clusterAlias, settings)) {
                throw new IllegalArgumentException("Cannot configure setting [" + this.key + "] if remote cluster is not enabled.");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return Stream.concat(Stream.of(REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.clusterAlias)), this.settingsStream()).iterator();
        }

        private Stream<Setting<?>> settingsStream() {
            return Arrays.stream(RemoteConnectionStrategy.ConnectionStrategy.values()).flatMap(RemoteClusterSettings::getEnablementSettings).map(as -> as.getConcreteSettingForNamespace(this.clusterAlias));
        }

        private static boolean isConnectionEnabled(String clusterAlias, Map<Setting<?>, Object> settings) {
            RemoteConnectionStrategy.ConnectionStrategy mode = (RemoteConnectionStrategy.ConnectionStrategy)((Object)settings.get(REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(clusterAlias)));
            return switch (mode) {
                default -> throw new MatchException(null, null);
                case RemoteConnectionStrategy.ConnectionStrategy.SNIFF -> {
                    if (!((List)settings.get(SniffConnectionStrategySettings.REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias))).isEmpty()) {
                        yield true;
                    }
                    yield false;
                }
                case RemoteConnectionStrategy.ConnectionStrategy.PROXY -> !((String)settings.get(ProxyConnectionStrategySettings.PROXY_ADDRESS.getConcreteSettingForNamespace(clusterAlias))).isEmpty();
            };
        }
    }

    private static class StrategyValidator<T>
    implements Setting.Validator<T> {
        private final String key;
        private final RemoteConnectionStrategy.ConnectionStrategy expectedStrategy;
        private final String namespace;
        private final Consumer<T> valueChecker;

        StrategyValidator(String namespace, String key, RemoteConnectionStrategy.ConnectionStrategy expectedStrategy) {
            this(namespace, key, expectedStrategy, v -> {});
        }

        StrategyValidator(String namespace, String key, RemoteConnectionStrategy.ConnectionStrategy expectedStrategy, Consumer<T> valueChecker) {
            this.namespace = namespace;
            this.key = key;
            this.expectedStrategy = expectedStrategy;
            this.valueChecker = valueChecker;
        }

        @Override
        public void validate(T value) {
            this.valueChecker.accept(value);
        }

        @Override
        public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
            Setting<RemoteConnectionStrategy.ConnectionStrategy> concrete = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.namespace);
            RemoteConnectionStrategy.ConnectionStrategy modeType = (RemoteConnectionStrategy.ConnectionStrategy)((Object)settings.get(concrete));
            if (isPresent && !modeType.equals((Object)this.expectedStrategy)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Setting \"%s\" cannot be used with the configured \"%s\" [required=%s, configured=%s]", this.key, concrete.getKey(), this.expectedStrategy.name(), modeType.name()));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            Setting<RemoteConnectionStrategy.ConnectionStrategy> concrete = REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.namespace);
            Stream<Setting<RemoteConnectionStrategy.ConnectionStrategy>> settingStream = Stream.of(concrete);
            return settingStream.iterator();
        }
    }
}

