/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafFieldLookupProvider;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.SourceProvider;

public class SearchLookup
implements SourceProvider {
    private static final int MAX_FIELD_CHAIN_DEPTH = 5;
    private final Set<String> fieldChain;
    private final SourceProvider sourceProvider;
    private final Function<String, MappedFieldType> fieldTypeLookup;
    private final Function<String, Boolean> onlyMappedAsRuntimeField;
    private final TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup;
    private final Function<LeafReaderContext, LeafFieldLookupProvider> fieldLookupProvider;

    public SearchLookup(Function<String, MappedFieldType> fieldTypeLookup, TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup, SourceProvider sourceProvider) {
        this(fieldTypeLookup, fieldName -> false, fieldDataLookup, sourceProvider, LeafFieldLookupProvider.fromStoredFields());
    }

    public SearchLookup(Function<String, MappedFieldType> fieldTypeLookup, Function<String, Boolean> onlyMappedAsRuntimeField, TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup, SourceProvider sourceProvider, Function<LeafReaderContext, LeafFieldLookupProvider> fieldLookupProvider) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.onlyMappedAsRuntimeField = onlyMappedAsRuntimeField;
        this.fieldChain = Collections.emptySet();
        this.sourceProvider = sourceProvider;
        this.fieldDataLookup = fieldDataLookup;
        this.fieldLookupProvider = fieldLookupProvider;
    }

    private SearchLookup(SearchLookup searchLookup, Set<String> fieldChain) {
        this.fieldChain = Collections.unmodifiableSet(fieldChain);
        this.sourceProvider = searchLookup.sourceProvider;
        this.fieldTypeLookup = searchLookup.fieldTypeLookup;
        this.onlyMappedAsRuntimeField = searchLookup.onlyMappedAsRuntimeField;
        this.fieldDataLookup = searchLookup.fieldDataLookup;
        this.fieldLookupProvider = searchLookup.fieldLookupProvider;
    }

    private SearchLookup(SearchLookup searchLookup, SourceProvider sourceProvider) {
        this.fieldChain = searchLookup.fieldChain;
        this.sourceProvider = sourceProvider;
        this.fieldTypeLookup = searchLookup.fieldTypeLookup;
        this.onlyMappedAsRuntimeField = searchLookup.onlyMappedAsRuntimeField;
        this.fieldDataLookup = searchLookup.fieldDataLookup;
        this.fieldLookupProvider = searchLookup.fieldLookupProvider;
    }

    public final SearchLookup forkAndTrackFieldReferences(String field) {
        Objects.requireNonNull(field, "field cannot be null");
        LinkedHashSet<String> newFieldChain = new LinkedHashSet<String>(this.fieldChain);
        if (!newFieldChain.add(field)) {
            String message = String.join((CharSequence)" -> ", newFieldChain) + " -> " + field;
            throw new IllegalArgumentException("Cyclic dependency detected while resolving runtime fields: " + message);
        }
        if (newFieldChain.size() > 5) {
            throw new IllegalArgumentException("Field requires resolving too many dependent fields: " + String.join((CharSequence)" -> ", newFieldChain));
        }
        return new SearchLookup(this, newFieldChain);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, new LeafDocLookup(this.fieldTypeLookup, this::getForField, context), this.sourceProvider, new LeafStoredFieldsLookup(this.fieldTypeLookup, this.fieldLookupProvider.apply(context)));
    }

    public MappedFieldType fieldType(String fieldName) {
        return this.fieldTypeLookup.apply(fieldName);
    }

    public boolean onlyMappedAsRuntimeField(String fieldName) {
        return this.onlyMappedAsRuntimeField.apply(fieldName);
    }

    public IndexFieldData<?> getForField(MappedFieldType fieldType, MappedFieldType.FielddataOperation options) {
        return this.fieldDataLookup.apply(fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name()), options);
    }

    @Override
    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        return this.sourceProvider.getSource(ctx, doc);
    }

    @Override
    public SearchLookup optimizedSourceProvider(SourceFilter sourceFilter) {
        SourceProvider copy = this.sourceProvider.optimizedSourceProvider(sourceFilter);
        return new SearchLookup(this, copy);
    }
}

