/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.repositories.RepositoriesStats;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class BlobStoreSnapshotMetrics {
    private final SnapshotMetrics snapshotMetrics;
    private final CounterMetric shardSnapshotsInProgress = new CounterMetric();
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric numberOfBlobsUploaded = new CounterMetric();
    private final CounterMetric numberOfBytesUploaded = new CounterMetric();
    private final CounterMetric uploadTimeInMillis = new CounterMetric();
    private final CounterMetric uploadReadTimeInNanos = new CounterMetric();
    private final CounterMetric numberOfShardSnapshotsStarted = new CounterMetric();
    private final CounterMetric numberOfShardSnapshotsCompleted = new CounterMetric();
    private final Map<String, Object> metricAttributes;

    public BlobStoreSnapshotMetrics(@Nullable ProjectId projectId, RepositoryMetadata repositoryMetadata, SnapshotMetrics snapshotMetrics) {
        if (projectId != null) {
            this.snapshotMetrics = snapshotMetrics;
            this.metricAttributes = SnapshotMetrics.createAttributesMap(projectId, repositoryMetadata);
        } else {
            this.snapshotMetrics = SnapshotMetrics.NOOP;
            this.metricAttributes = Map.of();
        }
    }

    public void incrementSnapshotRateLimitingTimeInNanos(long throttleTimeNanos) {
        this.snapshotMetrics.createThrottleDurationCounter().incrementBy(throttleTimeNanos, this.metricAttributes);
        this.snapshotRateLimitingTimeInNanos.inc(throttleTimeNanos);
    }

    public void incrementRestoreRateLimitingTimeInNanos(long throttleTimeNanos) {
        this.snapshotMetrics.restoreThrottleDurationCounter().incrementBy(throttleTimeNanos, this.metricAttributes);
        this.restoreRateLimitingTimeInNanos.inc(throttleTimeNanos);
    }

    public void incrementCountersForPartUpload(long partSizeInBytes, long partWriteTimeMillis) {
        this.snapshotMetrics.bytesUploadedCounter().incrementBy(partSizeInBytes, this.metricAttributes);
        this.snapshotMetrics.uploadDurationCounter().incrementBy(partWriteTimeMillis, this.metricAttributes);
        this.numberOfBytesUploaded.inc(partSizeInBytes);
        this.uploadTimeInMillis.inc(partWriteTimeMillis);
    }

    public void incrementNumberOfBlobsUploaded() {
        this.snapshotMetrics.blobsUploadedCounter().incrementBy(1L, this.metricAttributes);
        this.numberOfBlobsUploaded.inc();
    }

    public void shardSnapshotStarted() {
        this.snapshotMetrics.shardsStartedCounter().incrementBy(1L, this.metricAttributes);
        this.numberOfShardSnapshotsStarted.inc();
        this.shardSnapshotsInProgress.inc();
    }

    public void shardSnapshotCompleted(IndexShardSnapshotStatus status) {
        Map<String, Object> attrsWithStage = Maps.copyMapWithAddedEntry(this.metricAttributes, "stage", status.getStage().name());
        this.snapshotMetrics.shardsCompletedCounter().incrementBy(1L, attrsWithStage);
        this.snapshotMetrics.shardsDurationHistogram().record((double)status.getTotalTimeMillis() / 1000.0, attrsWithStage);
        this.numberOfShardSnapshotsCompleted.inc();
        this.shardSnapshotsInProgress.dec();
    }

    public void incrementUploadReadTime(long readTimeInMillis) {
        this.snapshotMetrics.uploadReadDurationCounter().incrementBy(readTimeInMillis, this.metricAttributes);
        this.uploadReadTimeInNanos.inc(readTimeInMillis);
    }

    public LongWithAttributes getShardSnapshotsInProgress() {
        return new LongWithAttributes(this.shardSnapshotsInProgress.count(), this.metricAttributes);
    }

    public RepositoriesStats.SnapshotStats getSnapshotStats() {
        return new RepositoriesStats.SnapshotStats(this.numberOfShardSnapshotsStarted.count(), this.numberOfShardSnapshotsCompleted.count(), this.shardSnapshotsInProgress.count(), this.restoreRateLimitingTimeInNanos.count(), this.snapshotRateLimitingTimeInNanos.count(), this.numberOfBlobsUploaded.count(), this.numberOfBytesUploaded.count(), this.uploadTimeInMillis.count(), this.uploadReadTimeInNanos.count());
    }
}

