/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;

public final class ByteArrayStreamInput
extends StreamInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayStreamInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public ByteArrayStreamInput(byte[] bytes) {
        this.reset(bytes);
    }

    @Override
    public String readString() throws IOException {
        int chars = this.readArraySize();
        String string = this.tryReadStringFromBytes(this.bytes, this.pos, this.limit, chars);
        if (string != null) {
            return string;
        }
        return this.doReadString(chars);
    }

    @Override
    public int read() throws IOException {
        if (this.limit - this.pos <= 0) {
            return -1;
        }
        return this.readByte() & 0xFF;
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public int length() {
        return this.limit;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public void skipBytes(long count) {
        this.pos += (int)count;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int available = this.available();
        if (n < (long)available) {
            this.pos += (int)n;
            return n;
        }
        this.pos = this.limit;
        return available;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.limit - this.pos;
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        int available = this.limit - this.pos;
        if (length > available) {
            ByteArrayStreamInput.throwEOF(length, available);
        }
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int available = this.limit - this.pos;
        if (available <= 0) {
            return -1;
        }
        int toRead = Math.min(len, available);
        this.readBytes(b, off, toRead);
        return toRead;
    }
}

