/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.function.LongSupplier;
import org.elasticsearch.core.TimeValue;

public class FrequencyCappedAction {
    private final LongSupplier currentTimeMillisSupplier;
    private TimeValue minInterval;
    private long next;

    public FrequencyCappedAction(LongSupplier currentTimeMillisSupplier, TimeValue initialDelay) {
        this.currentTimeMillisSupplier = currentTimeMillisSupplier;
        this.minInterval = TimeValue.MAX_VALUE;
        this.next = currentTimeMillisSupplier.getAsLong() + initialDelay.getMillis();
    }

    public void setMinInterval(TimeValue minInterval) {
        this.minInterval = minInterval;
    }

    public void maybeExecute(Runnable runnable) {
        long current = this.currentTimeMillisSupplier.getAsLong();
        if (current >= this.next) {
            this.next = current + this.minInterval.millis();
            runnable.run();
        }
    }
}

