/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.type.SupportedVersion;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public final class DataType
extends Enum<DataType>
implements Writeable {
    public static final /* enum */ DataType UNSUPPORTED = new DataType(DataType.builder().typeName("UNSUPPORTED").estimatedSize(1024).supportedOnAllNodes());
    public static final /* enum */ DataType NULL = new DataType(DataType.builder().esType("null").estimatedSize(0).supportedOnAllNodes());
    public static final /* enum */ DataType BOOLEAN = new DataType(DataType.builder().esType("boolean").estimatedSize(1).supportedOnAllNodes());
    public static final /* enum */ DataType COUNTER_LONG = new DataType(DataType.builder().esType("counter_long").estimatedSize(8).docValues().counter().supportedOnAllNodes());
    public static final /* enum */ DataType COUNTER_INTEGER = new DataType(DataType.builder().esType("counter_integer").estimatedSize(4).docValues().counter().supportedOnAllNodes());
    public static final /* enum */ DataType COUNTER_DOUBLE = new DataType(DataType.builder().esType("counter_double").estimatedSize(8).docValues().counter().supportedOnAllNodes());
    public static final /* enum */ DataType LONG = new DataType(DataType.builder().esType("long").estimatedSize(8).wholeNumber().docValues().counter(COUNTER_LONG).supportedOnAllNodes());
    public static final /* enum */ DataType INTEGER = new DataType(DataType.builder().esType("integer").estimatedSize(4).wholeNumber().docValues().counter(COUNTER_INTEGER).supportedOnAllNodes());
    public static final /* enum */ DataType UNSIGNED_LONG = new DataType(DataType.builder().esType("unsigned_long").estimatedSize(8).wholeNumber().docValues().supportedOnAllNodes());
    public static final /* enum */ DataType DOUBLE = new DataType(DataType.builder().esType("double").estimatedSize(8).rationalNumber().docValues().counter(COUNTER_DOUBLE).supportedOnAllNodes());
    public static final /* enum */ DataType SHORT = new DataType(DataType.builder().esType("short").estimatedSize(2).wholeNumber().docValues().widenSmallNumeric(INTEGER).supportedOnAllNodes());
    public static final /* enum */ DataType BYTE = new DataType(DataType.builder().esType("byte").estimatedSize(1).wholeNumber().docValues().widenSmallNumeric(INTEGER).supportedOnAllNodes());
    public static final /* enum */ DataType FLOAT = new DataType(DataType.builder().esType("float").estimatedSize(4).rationalNumber().docValues().widenSmallNumeric(DOUBLE).supportedOnAllNodes());
    public static final /* enum */ DataType HALF_FLOAT = new DataType(DataType.builder().esType("half_float").estimatedSize(4).rationalNumber().docValues().widenSmallNumeric(DOUBLE).supportedOnAllNodes());
    public static final /* enum */ DataType SCALED_FLOAT = new DataType(DataType.builder().esType("scaled_float").estimatedSize(8).rationalNumber().docValues().widenSmallNumeric(DOUBLE).supportedOnAllNodes());
    public static final /* enum */ DataType KEYWORD = new DataType(DataType.builder().esType("keyword").estimatedSize(50).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType TEXT = new DataType(DataType.builder().esType("text").estimatedSize(1024).supportedOnAllNodes());
    public static final /* enum */ DataType DATETIME = new DataType(DataType.builder().esType("date").typeName("DATETIME").estimatedSize(8).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType DATE_NANOS = new DataType(DataType.builder().esType("date_nanos").estimatedSize(8).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType IP = new DataType(DataType.builder().esType("ip").estimatedSize(16).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType VERSION = new DataType(DataType.builder().esType("version").estimatedSize(15).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType OBJECT = new DataType(DataType.builder().esType("object").estimatedSize(1024).supportedOnAllNodes());
    public static final /* enum */ DataType SOURCE = new DataType(DataType.builder().esType("_source").estimatedSize(10240).supportedOnAllNodes());
    public static final /* enum */ DataType DATE_PERIOD = new DataType(DataType.builder().typeName("DATE_PERIOD").estimatedSize(12).supportedOnAllNodes());
    public static final /* enum */ DataType TIME_DURATION = new DataType(DataType.builder().typeName("TIME_DURATION").estimatedSize(12).supportedOnAllNodes());
    public static final /* enum */ DataType GEO_POINT = new DataType(DataType.builder().esType("geo_point").estimatedSize(21).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType CARTESIAN_POINT = new DataType(DataType.builder().esType("cartesian_point").estimatedSize(21).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType CARTESIAN_SHAPE = new DataType(DataType.builder().esType("cartesian_shape").estimatedSize(200).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType GEO_SHAPE = new DataType(DataType.builder().esType("geo_shape").estimatedSize(200).docValues().supportedOnAllNodes());
    public static final /* enum */ DataType GEOHASH = new DataType(DataType.builder().esType("geohash").typeName("GEOHASH").estimatedSize(8).supportedSince(DataTypesTransportVersions.INDEX_SOURCE));
    public static final /* enum */ DataType GEOTILE = new DataType(DataType.builder().esType("geotile").typeName("GEOTILE").estimatedSize(8).supportedSince(DataTypesTransportVersions.INDEX_SOURCE));
    public static final /* enum */ DataType GEOHEX = new DataType(DataType.builder().esType("geohex").typeName("GEOHEX").estimatedSize(8).supportedSince(DataTypesTransportVersions.INDEX_SOURCE));
    public static final /* enum */ DataType DOC_DATA_TYPE = new DataType(DataType.builder().esType("_doc").estimatedSize(12).supportedOnAllNodes());
    public static final /* enum */ DataType TSID_DATA_TYPE = new DataType(DataType.builder().esType("_tsid").estimatedSize(16).docValues().supportedSince(DataTypesTransportVersions.INDEX_SOURCE));
    public static final /* enum */ DataType PARTIAL_AGG = new DataType(DataType.builder().esType("partial_agg").estimatedSize(1024).supportedOnAllNodes());
    public static final /* enum */ DataType AGGREGATE_METRIC_DOUBLE = new DataType(DataType.builder().esType("aggregate_metric_double").estimatedSize(28).supportedSince(DataTypesTransportVersions.ESQL_AGGREGATE_METRIC_DOUBLE_CREATED_VERSION));
    public static final /* enum */ DataType DENSE_VECTOR = new DataType(DataType.builder().esType("dense_vector").estimatedSize(4096).supportedSince(DataTypesTransportVersions.ESQL_DENSE_VECTOR_CREATED_VERSION));
    public static final Set<DataType> UNDER_CONSTRUCTION;
    private final String typeName;
    private final String name;
    private final String esType;
    private final int estimatedSize;
    private final boolean isWholeNumber;
    private final boolean isRationalNumber;
    private final boolean docValues;
    private final boolean isCounter;
    private final DataType widenSmallNumeric;
    private final DataType counter;
    private final SupportedVersion supportedVersion;
    private static final Collection<DataType> TYPES;
    private static final Collection<DataType> STRING_TYPES;
    private static final Map<String, DataType> NAME_TO_TYPE;
    private static final Map<String, DataType> ES_TO_TYPE;
    private static final Map<String, DataType> NAME_OR_ALIAS_TO_TYPE;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(Builder builder) {
        String typeString = builder.typeName != null ? builder.typeName : builder.esType;
        this.typeName = typeString.toLowerCase(Locale.ROOT);
        this.name = typeString.toUpperCase(Locale.ROOT);
        this.esType = builder.esType;
        this.estimatedSize = Objects.requireNonNull(builder.estimatedSize, "estimated size is required");
        this.isWholeNumber = builder.isWholeNumber;
        this.isRationalNumber = builder.isRationalNumber;
        this.docValues = builder.docValues;
        this.isCounter = builder.isCounter;
        this.widenSmallNumeric = builder.widenSmallNumeric;
        this.counter = builder.counter;
        assert (builder.supportedVersion != null) : "version from when a data type is supported is required";
        this.supportedVersion = builder.supportedVersion;
    }

    public static Collection<DataType> types() {
        return TYPES;
    }

    public static Collection<DataType> stringTypes() {
        return STRING_TYPES;
    }

    public static DataType fromTypeName(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public static DataType fromEs(String name) {
        DataType type = ES_TO_TYPE.get(name);
        if (type == null || !type.supportedVersion().supportedLocally()) {
            return UNSUPPORTED;
        }
        return type;
    }

    public static DataType fromJava(Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, BigInteger.class, Boolean.class, Double.class, Float.class, Byte.class, Short.class, ZonedDateTime.class, List.class}, (Object)object, n)) {
            case -1: {
                return NULL;
            }
            case 0: {
                Integer i = (Integer)object;
                return INTEGER;
            }
            case 1: {
                Long l = (Long)object;
                return LONG;
            }
            case 2: {
                BigInteger bigInteger = (BigInteger)object;
                return UNSIGNED_LONG;
            }
            case 3: {
                Boolean b = (Boolean)object;
                return BOOLEAN;
            }
            case 4: {
                Double v = (Double)object;
                return DOUBLE;
            }
            case 5: {
                Float v = (Float)object;
                return FLOAT;
            }
            case 6: {
                Byte b = (Byte)object;
                return BYTE;
            }
            case 7: {
                Short i = (Short)object;
                return SHORT;
            }
            case 8: {
                ZonedDateTime zonedDateTime = (ZonedDateTime)object;
                return DATETIME;
            }
            case 9: {
                List list = (List)object;
                if (list.isEmpty()) {
                    return null;
                }
                return DataType.fromJava(list.getFirst());
            }
        }
        if (value instanceof String || value instanceof Character || value instanceof BytesRef) {
            return KEYWORD;
        }
        return null;
    }

    public static boolean isUnsupported(DataType from) {
        return from == UNSUPPORTED;
    }

    public static boolean isString(DataType t) {
        return t == KEYWORD || t == TEXT;
    }

    public static boolean isPrimitiveAndSupported(DataType t) {
        return DataType.isPrimitive(t) && t != UNSUPPORTED;
    }

    public static boolean isPrimitive(DataType t) {
        return t != OBJECT;
    }

    public static boolean isNull(DataType t) {
        return t == NULL;
    }

    public static boolean isNullOrNumeric(DataType t) {
        return t.isNumeric() || DataType.isNull(t);
    }

    public static boolean isDateTime(DataType type) {
        return type == DATETIME;
    }

    public static boolean isTimeDuration(DataType t) {
        return t == TIME_DURATION;
    }

    public static boolean isDateNanos(DataType t) {
        return t == DATE_NANOS;
    }

    public static boolean isNullOrTimeDuration(DataType t) {
        return t == TIME_DURATION || DataType.isNull(t);
    }

    public static boolean isNullOrDatePeriod(DataType t) {
        return t == DATE_PERIOD || DataType.isNull(t);
    }

    public static boolean isTemporalAmount(DataType t) {
        return t == DATE_PERIOD || t == TIME_DURATION;
    }

    public static boolean isNullOrTemporalAmount(DataType t) {
        return DataType.isTemporalAmount(t) || DataType.isNull(t);
    }

    public static boolean isDateTimeOrTemporal(DataType t) {
        return DataType.isDateTime(t) || DataType.isTemporalAmount(t);
    }

    public static boolean isDateTimeOrNanosOrTemporal(DataType t) {
        return DataType.isDateTime(t) || DataType.isTemporalAmount(t) || t == DATE_NANOS;
    }

    public static boolean isMillisOrNanos(DataType t) {
        return t == DATETIME || t == DATE_NANOS;
    }

    public static boolean areCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == NULL || right == NULL || DataType.isString(left) && DataType.isString(right) || left.isNumeric() && right.isNumeric();
    }

    public static boolean isRepresentable(DataType t) {
        return t != OBJECT && t != UNSUPPORTED && t != DATE_PERIOD && t != TIME_DURATION && t != BYTE && t != SHORT && t != FLOAT && t != SCALED_FLOAT && t != SOURCE && t != HALF_FLOAT && t != PARTIAL_AGG && !t.isCounter();
    }

    public static boolean isCounter(DataType t) {
        return t == COUNTER_DOUBLE || t == COUNTER_INTEGER || t == COUNTER_LONG;
    }

    public static boolean isSpatialPoint(DataType t) {
        return DataType.isGeoPoint(t) || DataType.isCartesianPoint(t);
    }

    public static boolean isGeoPoint(DataType t) {
        return t == GEO_POINT;
    }

    public static boolean isCartesianPoint(DataType t) {
        return t == CARTESIAN_POINT;
    }

    public static boolean isSpatialShape(DataType t) {
        return t == GEO_SHAPE || t == CARTESIAN_SHAPE || t == GEOHASH || t == GEOTILE || t == GEOHEX;
    }

    public static boolean isSpatialGeo(DataType t) {
        return t == GEO_POINT || t == GEO_SHAPE || t == GEOHASH || t == GEOTILE || t == GEOHEX;
    }

    public static boolean isSpatial(DataType t) {
        return t == GEO_POINT || t == CARTESIAN_POINT || t == GEO_SHAPE || t == CARTESIAN_SHAPE;
    }

    public static boolean isSpatialOrGrid(DataType t) {
        return DataType.isSpatial(t) || DataType.isGeoGrid(t);
    }

    public static boolean isGeoGrid(DataType t) {
        return t == GEOHASH || t == GEOTILE || t == GEOHEX;
    }

    public static boolean isSortable(DataType t) {
        return false == (t == SOURCE || DataType.isCounter(t) || DataType.isSpatialOrGrid(t) || t == AGGREGATE_METRIC_DOUBLE);
    }

    public String nameUpper() {
        return this.name;
    }

    public String typeName() {
        return this.typeName;
    }

    public String esType() {
        return this.esType;
    }

    public String esNameIfPossible() {
        return this.esType != null ? this.esType : this.typeName;
    }

    public String outputType() {
        return this.esType == null ? "unsupported" : this.esType;
    }

    public boolean isWholeNumber() {
        return this.isWholeNumber;
    }

    public boolean isRationalNumber() {
        return this.isRationalNumber;
    }

    public boolean isNumeric() {
        return this.isWholeNumber || this.isRationalNumber;
    }

    public int estimatedSize() {
        return this.estimatedSize;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public boolean isCounter() {
        return this.isCounter;
    }

    public DataType widenSmallNumeric() {
        return this.widenSmallNumeric == null ? this : this.widenSmallNumeric;
    }

    public DataType counter() {
        return this.counter;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (!this.supportedVersion.supportedOn(out.getTransportVersion(), Build.current().isSnapshot())) {
            throw new QlIllegalArgumentException("remote node at version [" + String.valueOf(out.getTransportVersion()) + "] doesn't understand data type [" + String.valueOf((Object)this) + "]");
        }
        ((PlanStreamOutput)out).writeCachedString(this.typeName);
    }

    public static DataType readFrom(StreamInput in) throws IOException {
        return DataType.readFrom(((PlanStreamInput)in).readCachedString());
    }

    public static DataType readFrom(String name) throws IOException {
        if (name.equalsIgnoreCase(DOC_DATA_TYPE.nameUpper())) {
            return DOC_DATA_TYPE;
        }
        DataType dataType = DataType.fromTypeName(name);
        if (dataType == null) {
            throw new IOException("Unknown DataType for type name: " + name);
        }
        return dataType;
    }

    public static Set<String> namesAndAliases() {
        return NAME_OR_ALIAS_TO_TYPE.keySet();
    }

    public static DataType fromNameOrAlias(String typeName) {
        DataType type = NAME_OR_ALIAS_TO_TYPE.get(typeName.toLowerCase(Locale.ROOT));
        return type != null ? type : UNSUPPORTED;
    }

    static Builder builder() {
        return new Builder();
    }

    public DataType noText() {
        return DataType.isString(this) ? KEYWORD : this;
    }

    public DataType noCounter() {
        return switch (this.ordinal()) {
            case 5 -> DOUBLE;
            case 4 -> INTEGER;
            case 3 -> LONG;
            default -> this;
        };
    }

    public boolean isDate() {
        return switch (this.ordinal()) {
            case 17, 18 -> true;
            default -> false;
        };
    }

    public SupportedVersion supportedVersion() {
        return this.supportedVersion;
    }

    public static DataType suggestedCast(Set<DataType> originalTypes) {
        if (originalTypes.isEmpty() || originalTypes.contains((Object)UNSUPPORTED)) {
            return null;
        }
        if (originalTypes.contains((Object)DATE_NANOS) && originalTypes.contains((Object)DATETIME) && originalTypes.size() == 2) {
            return DATE_NANOS;
        }
        if (originalTypes.contains((Object)AGGREGATE_METRIC_DOUBLE)) {
            boolean allNumeric = true;
            for (DataType type : originalTypes) {
                if (type.isNumeric() || type == AGGREGATE_METRIC_DOUBLE) continue;
                allNumeric = false;
                break;
            }
            if (allNumeric) {
                return AGGREGATE_METRIC_DOUBLE;
            }
        }
        return KEYWORD;
    }

    private static /* synthetic */ DataType[] $values() {
        return new DataType[]{UNSUPPORTED, NULL, BOOLEAN, COUNTER_LONG, COUNTER_INTEGER, COUNTER_DOUBLE, LONG, INTEGER, UNSIGNED_LONG, DOUBLE, SHORT, BYTE, FLOAT, HALF_FLOAT, SCALED_FLOAT, KEYWORD, TEXT, DATETIME, DATE_NANOS, IP, VERSION, OBJECT, SOURCE, DATE_PERIOD, TIME_DURATION, GEO_POINT, CARTESIAN_POINT, CARTESIAN_SHAPE, GEO_SHAPE, GEOHASH, GEOTILE, GEOHEX, DOC_DATA_TYPE, TSID_DATA_TYPE, PARTIAL_AGG, AGGREGATE_METRIC_DOUBLE, DENSE_VECTOR};
    }

    static {
        $VALUES = DataType.$values();
        UNDER_CONSTRUCTION = Arrays.stream(DataType.values()).filter(t -> t.supportedVersion() == SupportedVersion.UNDER_CONSTRUCTION).collect(Collectors.toSet());
        TYPES = Arrays.stream(DataType.values()).filter(d -> d != DOC_DATA_TYPE).sorted(Comparator.comparing(DataType::typeName)).toList();
        STRING_TYPES = DataType.types().stream().filter(DataType::isString).toList();
        Map<String, DataType> map = TYPES.stream().filter(e -> e.esType() != null).collect(Collectors.toMap(DataType::esType, t -> t));
        map.put("point", CARTESIAN_POINT);
        map.put("shape", CARTESIAN_SHAPE);
        map.put("semantic_text", TEXT);
        ES_TO_TYPE = Collections.unmodifiableMap(map);
        map = TYPES.stream().collect(Collectors.toMap(DataType::typeName, t -> t));
        map.put("date", DATETIME);
        NAME_TO_TYPE = Collections.unmodifiableMap(map);
        map = DataType.types().stream().collect(Collectors.toMap(DataType::typeName, Function.identity()));
        map.put("bool", BOOLEAN);
        map.put("int", INTEGER);
        map.put("string", KEYWORD);
        map.put("date", DATETIME);
        NAME_OR_ALIAS_TO_TYPE = Collections.unmodifiableMap(map);
    }

    private static class Builder {
        private String esType;
        private String typeName;
        private Integer estimatedSize;
        private boolean isWholeNumber;
        private boolean isRationalNumber;
        private boolean docValues;
        private boolean isCounter;
        private DataType widenSmallNumeric;
        private DataType counter;
        private SupportedVersion supportedVersion;

        Builder() {
        }

        Builder esType(String esType) {
            this.esType = esType;
            return this;
        }

        Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        Builder estimatedSize(int size) {
            this.estimatedSize = size;
            return this;
        }

        Builder wholeNumber() {
            this.isWholeNumber = true;
            return this;
        }

        Builder rationalNumber() {
            this.isRationalNumber = true;
            return this;
        }

        Builder docValues() {
            this.docValues = true;
            return this;
        }

        Builder counter() {
            this.isCounter = true;
            return this;
        }

        Builder widenSmallNumeric(DataType widenSmallNumeric) {
            this.widenSmallNumeric = widenSmallNumeric;
            return this;
        }

        Builder counter(DataType counter) {
            assert (counter.isCounter);
            this.counter = counter;
            return this;
        }

        Builder supportedSince(TransportVersion supportedVersion) {
            this.supportedVersion = SupportedVersion.supportedSince(supportedVersion);
            return this;
        }

        Builder supportedOnAllNodes() {
            this.supportedVersion = SupportedVersion.SUPPORTED_ON_ALL_NODES;
            return this;
        }

        Builder underConstruction() {
            this.supportedVersion = SupportedVersion.UNDER_CONSTRUCTION;
            return this;
        }
    }

    public static class DataTypesTransportVersions {
        public static final TransportVersion INDEX_SOURCE = TransportVersion.fromName((String)"index_source");
        public static final TransportVersion ESQL_DENSE_VECTOR_CREATED_VERSION = TransportVersion.fromName((String)"esql_dense_vector_created_version");
        public static final TransportVersion ESQL_AGGREGATE_METRIC_DOUBLE_CREATED_VERSION = TransportVersion.fromName((String)"esql_aggregate_metric_double_created_version");
    }
}

