/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.rules.action.TestQueryRulesetAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestTestQueryRulesetAction
extends EnterpriseSearchBaseRestHandler {
    public RestTestQueryRulesetAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.QUERY_RULES);
    }

    public String getName() {
        return "query_ruleset_test_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_query_rules/{ruleset_id}/_test"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String rulesetId = restRequest.param("ruleset_id");
        TestQueryRulesetAction.Request request = null;
        if (restRequest.hasContent()) {
            try (XContentParser parser = restRequest.contentParser();){
                request = TestQueryRulesetAction.Request.parse(parser, rulesetId);
            }
        }
        TestQueryRulesetAction.Request finalRequest = request;
        return channel -> client.execute(TestQueryRulesetAction.INSTANCE, (ActionRequest)finalRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

