/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.useragent;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.useragent.UserAgentCache;
import org.elasticsearch.ingest.useragent.UserAgentParser;
import org.elasticsearch.ingest.useragent.UserAgentProcessor;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;

public class IngestUserAgentPlugin
extends Plugin
implements IngestPlugin {
    private final Setting<Long> CACHE_SIZE_SETTING = Setting.longSetting((String)"ingest.user_agent.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final String DEFAULT_PARSER_NAME = "_default_";

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        Map<String, UserAgentParser> userAgentParsers;
        Path userAgentConfigDirectory = parameters.env.configDir().resolve("ingest-user-agent");
        if (!Files.exists(userAgentConfigDirectory, new LinkOption[0]) && Files.isDirectory(userAgentConfigDirectory, new LinkOption[0])) {
            throw new IllegalStateException("the user agent directory [" + String.valueOf(userAgentConfigDirectory) + "] containing the regex file doesn't exist");
        }
        long cacheSize = (Long)this.CACHE_SIZE_SETTING.get(parameters.env.settings());
        try {
            userAgentParsers = IngestUserAgentPlugin.createUserAgentParsers(userAgentConfigDirectory, new UserAgentCache(cacheSize));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Map.of("user_agent", new UserAgentProcessor.Factory(userAgentParsers));
    }

    static Map<String, UserAgentParser> createUserAgentParsers(Path userAgentConfigDirectory, UserAgentCache cache) throws IOException {
        HashMap<String, UserAgentParser> userAgentParsers = new HashMap<String, UserAgentParser>();
        UserAgentParser defaultParser = new UserAgentParser(DEFAULT_PARSER_NAME, IngestUserAgentPlugin.class.getResourceAsStream("/regexes.yml"), IngestUserAgentPlugin.class.getResourceAsStream("/device_type_regexes.yml"), cache);
        userAgentParsers.put(DEFAULT_PARSER_NAME, defaultParser);
        if (Files.exists(userAgentConfigDirectory, new LinkOption[0]) && Files.isDirectory(userAgentConfigDirectory, new LinkOption[0])) {
            PathMatcher pathMatcher = userAgentConfigDirectory.getFileSystem().getPathMatcher("glob:**.yml");
            try (Stream<Path> regexFiles = Files.find(userAgentConfigDirectory, 1, (path, attr) -> attr.isRegularFile() && pathMatcher.matches((Path)path), new FileVisitOption[0]);){
                Iterable iterable = regexFiles::iterator;
                for (Path path2 : iterable) {
                    String parserName = path2.getFileName().toString();
                    InputStream regexStream = Files.newInputStream(path2, StandardOpenOption.READ);
                    try {
                        InputStream deviceTypeRegexStream = IngestUserAgentPlugin.class.getResourceAsStream("/device_type_regexes.yml");
                        try {
                            userAgentParsers.put(parserName, new UserAgentParser(parserName, regexStream, deviceTypeRegexStream, cache));
                        }
                        finally {
                            if (deviceTypeRegexStream == null) continue;
                            deviceTypeRegexStream.close();
                        }
                    }
                    finally {
                        if (regexStream == null) continue;
                        regexStream.close();
                    }
                }
            }
        }
        return Map.copyOf(userAgentParsers);
    }

    public List<Setting<?>> getSettings() {
        return List.of(this.CACHE_SIZE_SETTING);
    }

    public Map<String, UnaryOperator<Metadata.ProjectCustom>> getProjectCustomMetadataUpgraders() {
        return Map.of("ingest", ingestMetadata -> ((IngestMetadata)ingestMetadata).maybeUpgradeProcessors("user_agent", UserAgentProcessor::maybeUpgradeConfig));
    }
}

