/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.deepseek.request;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.unified.UnifiedChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.deepseek.DeepSeekChatCompletionModel;

public class DeepSeekChatCompletionRequest
implements Request {
    private static final Logger logger = LogManager.getLogger(DeepSeekChatCompletionRequest.class);
    private static final String MODEL_FIELD = "model";
    private static final String MAX_TOKENS = "max_tokens";
    private final DeepSeekChatCompletionModel model;
    private final UnifiedChatInput unifiedChatInput;

    public DeepSeekChatCompletionRequest(UnifiedChatInput unifiedChatInput, DeepSeekChatCompletionModel model) {
        this.unifiedChatInput = Objects.requireNonNull(unifiedChatInput);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.uri());
        httpPost.setEntity((HttpEntity)this.createEntity());
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.model.apiKey().ifPresentOrElse(apiKey -> httpPost.setHeader(RequestUtils.createAuthBearerHeader(apiKey)), () -> logger.debug("No auth token present in request, sending without auth..."));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    private ByteArrayEntity createEntity() {
        ByteArrayEntity byteArrayEntity;
        block8: {
            String modelId = Objects.requireNonNullElseGet(this.unifiedChatInput.getRequest().model(), this.model::model);
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.startObject();
                new UnifiedChatCompletionRequestEntity(this.unifiedChatInput).toXContent(builder, UnifiedCompletionRequest.withMaxTokens((String)modelId, (ToXContent.Params)ToXContent.EMPTY_PARAMS));
                builder.endObject();
                byteArrayEntity = new ByteArrayEntity(Strings.toString((XContentBuilder)builder).getBytes(StandardCharsets.UTF_8));
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Failed to serialize request payload.", (Throwable)e, new Object[0]);
                }
            }
            builder.close();
        }
        return byteArrayEntity;
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public boolean isStreaming() {
        return this.unifiedChatInput.stream();
    }
}

