/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j2;

import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.JsonUtils;
import co.elastic.logging.log4j2.MdcSerializer;
import co.elastic.logging.log4j2.MdcSerializerResolver;
import co.elastic.logging.log4j2.MultiFormatHandler;
import co.elastic.logging.log4j2.ObjectMessageJacksonSerializer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;

@Plugin(name="EcsLayout", category="Core", elementType="layout")
public class EcsLayout
extends AbstractStringLayout {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final ObjectMessageJacksonSerializer JACKSON_SERIALIZER = ObjectMessageJacksonSerializer.Resolver.resolve();
    private static final MultiFormatHandler MULTI_FORMAT_HANDLER = MultiFormatHandler.Resolver.resolve();
    private static final boolean FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS = PropertiesUtil.getProperties().getBooleanProperty("log4j2.formatMsgNoLookups", false);
    private final KeyValuePair[] additionalFields;
    private final PatternFormatter[][] fieldValuePatternFormatter;
    private final boolean stackTraceAsArray;
    private final String serviceName;
    private final String serviceVersion;
    private final String serviceEnvironment;
    private final String serviceNodeName;
    private final String eventDataset;
    private final boolean includeMarkers;
    private final boolean includeOrigin;
    private final PatternFormatter[] exceptionPatternFormatter;
    private final ConcurrentMap<Class<? extends MultiformatMessage>, Boolean> supportsJson = new ConcurrentHashMap<Class<? extends MultiformatMessage>, Boolean>();
    private final MdcSerializer mdcSerializer;

    private EcsLayout(Configuration config, String serviceName, String serviceVersion, String serviceEnvironment, String serviceNodeName, String eventDataset, boolean includeMarkers, KeyValuePair[] additionalFields, boolean includeOrigin, String exceptionPattern, boolean stackTraceAsArray, String mdcSerializerFullClassName) {
        super(config, UTF_8, null, null);
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.serviceEnvironment = serviceEnvironment;
        this.serviceNodeName = serviceNodeName;
        this.eventDataset = eventDataset;
        this.includeMarkers = includeMarkers;
        this.includeOrigin = includeOrigin;
        this.stackTraceAsArray = stackTraceAsArray;
        this.additionalFields = additionalFields;
        this.fieldValuePatternFormatter = new PatternFormatter[additionalFields.length][];
        for (int i = 0; i < additionalFields.length; ++i) {
            KeyValuePair additionalField = additionalFields[i];
            if (!additionalField.getValue().contains("%")) continue;
            this.fieldValuePatternFormatter[i] = PatternLayout.createPatternParser((Configuration)config).parse(additionalField.getValue()).toArray(new PatternFormatter[0]);
        }
        this.exceptionPatternFormatter = exceptionPattern != null && !exceptionPattern.isEmpty() ? PatternLayout.createPatternParser((Configuration)config).parse(exceptionPattern).toArray(new PatternFormatter[0]) : null;
        this.mdcSerializer = MdcSerializerResolver.resolve(mdcSerializerFullClassName);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private static boolean valueNeedsLookup(String value) {
        return value != null && value.contains("${");
    }

    public String toSerializable(LogEvent event) {
        StringBuilder text = this.toText(event, EcsLayout.getStringBuilder(), false);
        return text.toString();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        StringBuilder text = this.toText(event, EcsLayout.getStringBuilder(), true);
        Encoder helper = this.getStringBuilderEncoder();
        helper.encode((Object)text, destination);
    }

    public String getContentType() {
        return "application/json";
    }

    private StringBuilder toText(LogEvent event, StringBuilder builder, boolean gcFree) {
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.getTimeMillis());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.getLevel().toString());
        this.serializeMessage(builder, gcFree, event.getMessage(), event.getThrown());
        EcsJsonSerializer.serializeEcsVersion((StringBuilder)builder);
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeServiceVersion((StringBuilder)builder, (String)this.serviceVersion);
        EcsJsonSerializer.serializeServiceEnvironment((StringBuilder)builder, (String)this.serviceEnvironment);
        EcsJsonSerializer.serializeServiceNodeName((StringBuilder)builder, (String)this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.getLoggerName());
        this.serializeAdditionalFieldsAndMDC(event, builder);
        this.serializeTags(event, builder);
        if (this.includeOrigin) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (StackTraceElement)event.getSource());
        }
        this.serializeException(builder, event);
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder;
    }

    private void serializeAdditionalFieldsAndMDC(LogEvent event, StringBuilder builder) {
        int length = this.additionalFields.length;
        if (length > 0) {
            StrSubstitutor strSubstitutor = this.getConfiguration().getStrSubstitutor();
            for (int i = 0; i < length; ++i) {
                KeyValuePair additionalField = this.additionalFields[i];
                PatternFormatter[] formatters = this.fieldValuePatternFormatter[i];
                CharSequence value = null;
                if (formatters != null) {
                    StringBuilder buffer = EcsJsonSerializer.getMessageStringBuilder();
                    EcsLayout.formatPattern(event, formatters, buffer);
                    if (buffer.length() > 0) {
                        value = buffer;
                    }
                } else if (EcsLayout.valueNeedsLookup(additionalField.getValue()) && !FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS) {
                    StringBuilder lookupValue = EcsJsonSerializer.getMessageStringBuilder();
                    lookupValue.append(additionalField.getValue());
                    if (strSubstitutor.replaceIn(event, lookupValue)) {
                        value = lookupValue;
                    }
                } else {
                    value = additionalField.getValue();
                }
                if (value == null) continue;
                builder.append('\"');
                JsonUtils.quoteAsString((CharSequence)additionalField.getKey(), (StringBuilder)builder);
                builder.append("\":\"");
                JsonUtils.quoteAsString((CharSequence)EcsJsonSerializer.toNullSafeString((CharSequence)value), (StringBuilder)builder);
                builder.append("\",");
            }
        }
        this.mdcSerializer.serializeMdc(event, builder);
    }

    private static void formatPattern(LogEvent event, PatternFormatter[] formatters, StringBuilder buffer) {
        int len = formatters.length;
        for (int i = 0; i < len; ++i) {
            formatters[i].format(event, buffer);
        }
    }

    private void serializeTags(LogEvent event, StringBuilder builder) {
        boolean hasTags;
        ThreadContext.ContextStack stack = event.getContextStack();
        List contextStack = stack == null ? Collections.emptyList() : stack.asList();
        Marker marker = event.getMarker();
        boolean bl = hasTags = !contextStack.isEmpty() || this.includeMarkers && marker != null;
        if (hasTags) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
        }
        if (!contextStack.isEmpty()) {
            int len = contextStack.size();
            for (int i = 0; i < len; ++i) {
                builder.append('\"');
                JsonUtils.quoteAsString((CharSequence)((CharSequence)contextStack.get(i)), (StringBuilder)builder);
                builder.append("\",");
            }
        }
        if (this.includeMarkers && marker != null) {
            this.serializeMarker(builder, marker);
        }
        if (hasTags) {
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)marker.getName());
        if (marker.hasParents()) {
            Marker[] parents = marker.getParents();
            for (int i = 0; i < parents.length; ++i) {
                this.serializeMarker(builder, parents[i]);
            }
        }
    }

    private void serializeMessage(StringBuilder builder, boolean gcFree, Message message, Throwable thrown) {
        if (message instanceof MultiformatMessage) {
            MultiformatMessage multiformatMessage = (MultiformatMessage)message;
            if (this.supportsJson(multiformatMessage)) {
                EcsLayout.serializeJsonMessage(builder, multiformatMessage);
            } else {
                this.serializeSimpleMessage(builder, gcFree, message, thrown);
            }
        } else if (JACKSON_SERIALIZER != null && message instanceof ObjectMessage) {
            StringBuilder jsonBuffer = EcsJsonSerializer.getMessageStringBuilder();
            JACKSON_SERIALIZER.formatTo(jsonBuffer, (ObjectMessage)message);
            EcsLayout.addJson(builder, jsonBuffer);
        } else {
            this.serializeSimpleMessage(builder, gcFree, message, thrown);
        }
    }

    private static void serializeJsonMessage(StringBuilder builder, MultiformatMessage message) {
        StringBuilder messageBuffer = EcsJsonSerializer.getMessageStringBuilder();
        MULTI_FORMAT_HANDLER.formatJsonTo(message, messageBuffer);
        EcsLayout.addJson(builder, messageBuffer);
    }

    private static void addJson(StringBuilder buffer, StringBuilder jsonBuffer) {
        if (EcsLayout.isObject(jsonBuffer)) {
            EcsLayout.moveToRoot(jsonBuffer);
            buffer.append((CharSequence)jsonBuffer);
            buffer.append(", ");
        } else {
            buffer.append("\"message\":");
            if (EcsLayout.isString(jsonBuffer)) {
                buffer.append((CharSequence)jsonBuffer);
            } else {
                buffer.append('\"');
                JsonUtils.quoteAsString((CharSequence)jsonBuffer, (StringBuilder)buffer);
                buffer.append('\"');
            }
            buffer.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeSimpleMessage(StringBuilder builder, boolean gcFree, Message message, Throwable thrown) {
        builder.append("\"message\":\"");
        if (message instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)((CharSequence)message), (StringBuilder)builder);
        } else if (gcFree && message instanceof StringBuilderFormattable) {
            StringBuilder messageBuffer = EcsJsonSerializer.getMessageStringBuilder();
            try {
                ((StringBuilderFormattable)message).formatTo(messageBuffer);
                JsonUtils.quoteAsString((CharSequence)messageBuffer, (StringBuilder)builder);
            }
            finally {
                EcsLayout.trimToMaxSizeCopy(messageBuffer);
            }
        } else {
            JsonUtils.quoteAsString((CharSequence)EcsJsonSerializer.toNullSafeString((CharSequence)message.getFormattedMessage()), (StringBuilder)builder);
        }
        builder.append("\", ");
    }

    static void trimToMaxSizeCopy(StringBuilder stringBuilder) {
        if (stringBuilder.length() > MAX_STRING_BUILDER_SIZE) {
            stringBuilder.setLength(MAX_STRING_BUILDER_SIZE);
            stringBuilder.trimToSize();
        }
    }

    private static boolean isObject(StringBuilder messageBuffer) {
        return messageBuffer.length() > 1 && messageBuffer.charAt(0) == '{' && messageBuffer.charAt(messageBuffer.length() - 1) == '}';
    }

    private static boolean isString(StringBuilder messageBuffer) {
        return messageBuffer.length() > 1 && messageBuffer.charAt(0) == '\"' && messageBuffer.charAt(messageBuffer.length() - 1) == '\"';
    }

    private static void moveToRoot(StringBuilder messageBuffer) {
        messageBuffer.setCharAt(0, ' ');
        messageBuffer.setCharAt(messageBuffer.length() - 1, ' ');
    }

    private boolean supportsJson(MultiformatMessage message) {
        Boolean supportsJson = (Boolean)this.supportsJson.get(message.getClass());
        if (supportsJson == null) {
            supportsJson = false;
            for (String format : message.getFormats()) {
                if (!format.equalsIgnoreCase("JSON")) continue;
                supportsJson = true;
                break;
            }
            this.supportsJson.put(message.getClass(), supportsJson);
        }
        return supportsJson;
    }

    private void serializeException(StringBuilder messageBuffer, LogEvent event) {
        Throwable thrown = event.getThrown();
        if (thrown != null) {
            if (this.exceptionPatternFormatter != null) {
                StringBuilder stackTrace = EcsJsonSerializer.getMessageStringBuilder();
                EcsLayout.formatPattern(event, this.exceptionPatternFormatter, stackTrace);
                EcsJsonSerializer.serializeException((StringBuilder)messageBuffer, (String)thrown.getClass().getName(), (CharSequence)thrown.getMessage(), (CharSequence)stackTrace, (boolean)this.stackTraceAsArray);
            } else {
                EcsJsonSerializer.serializeException((StringBuilder)messageBuffer, (Throwable)thrown, (boolean)this.stackTraceAsArray);
            }
        }
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<EcsLayout> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute(value="serviceName")
        private String serviceName;
        @PluginBuilderAttribute(value="serviceVersion")
        private String serviceVersion;
        @PluginBuilderAttribute(value="serviceEnvironment")
        private String serviceEnvironment;
        @PluginBuilderAttribute(value="serviceNodeName")
        private String serviceNodeName;
        @PluginBuilderAttribute(value="eventDataset")
        private String eventDataset;
        @PluginBuilderAttribute(value="includeMarkers")
        private boolean includeMarkers = false;
        @PluginBuilderAttribute(value="exceptionPattern")
        private String exceptionPattern;
        @PluginBuilderAttribute(value="stackTraceAsArray")
        private boolean stackTraceAsArray = false;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields = new KeyValuePair[0];
        @PluginBuilderAttribute(value="includeOrigin")
        private boolean includeOrigin = false;
        @PluginBuilderAttribute(value="mdcSerializer")
        private String mdcSerializerFullClassName = "";

        Builder() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public KeyValuePair[] getAdditionalFields() {
            return (KeyValuePair[])this.additionalFields.clone();
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public String getServiceEnvironment() {
            return this.serviceEnvironment;
        }

        public String getServiceNodeName() {
            return this.serviceNodeName;
        }

        public String getEventDataset() {
            return this.eventDataset;
        }

        public boolean isIncludeMarkers() {
            return this.includeMarkers;
        }

        public boolean isIncludeOrigin() {
            return this.includeOrigin;
        }

        public boolean isStackTraceAsArray() {
            return this.stackTraceAsArray;
        }

        public String getExceptionPattern() {
            return this.exceptionPattern;
        }

        public String getMdcSerializerFullClassName() {
            return this.mdcSerializerFullClassName;
        }

        public Builder setAdditionalFields(KeyValuePair[] additionalFields) {
            this.additionalFields = (KeyValuePair[])additionalFields.clone();
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder setServiceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
            return this;
        }

        public Builder setServiceNodeName(String serviceNodeName) {
            this.serviceNodeName = serviceNodeName;
            return this;
        }

        public Builder setEventDataset(String eventDataset) {
            this.eventDataset = eventDataset;
            return this;
        }

        public Builder setIncludeMarkers(boolean includeMarkers) {
            this.includeMarkers = includeMarkers;
            return this;
        }

        public Builder setIncludeOrigin(boolean includeOrigin) {
            this.includeOrigin = includeOrigin;
            return this;
        }

        public Builder setStackTraceAsArray(boolean stackTraceAsArray) {
            this.stackTraceAsArray = stackTraceAsArray;
            return this;
        }

        public Builder setExceptionPattern(String exceptionPattern) {
            this.exceptionPattern = exceptionPattern;
            return this;
        }

        public Builder setMdcSerializerFullClassName(String mdcSerializerFullClassName) {
            this.mdcSerializerFullClassName = mdcSerializerFullClassName;
            return this;
        }

        public EcsLayout build() {
            return new EcsLayout(this.getConfiguration(), this.serviceName, this.serviceVersion, this.serviceEnvironment, this.serviceNodeName, EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName), this.includeMarkers, this.additionalFields, this.includeOrigin, this.exceptionPattern, this.stackTraceAsArray, this.mdcSerializerFullClassName);
        }
    }
}

