/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.HealthPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.snapshots.RegisteredPolicySnapshots;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.core.slm.action.GetSLMStatusAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.StartSLMAction;
import org.elasticsearch.xpack.core.slm.action.StopSLMAction;
import org.elasticsearch.xpack.slm.SLMInfoTransportAction;
import org.elasticsearch.xpack.slm.SLMUsageTransportAction;
import org.elasticsearch.xpack.slm.SlmHealthIndicatorService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;
import org.elasticsearch.xpack.slm.SnapshotRetentionService;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;
import org.elasticsearch.xpack.slm.TransportSLMGetExpiredSnapshotsAction;
import org.elasticsearch.xpack.slm.action.ReservedSnapshotAction;
import org.elasticsearch.xpack.slm.action.RestDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.action.RestGetSLMStatusAction;
import org.elasticsearch.xpack.slm.action.RestGetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestGetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.action.RestPutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestStartSLMAction;
import org.elasticsearch.xpack.slm.action.RestStopSLMAction;
import org.elasticsearch.xpack.slm.action.TransportDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.action.TransportGetSLMStatusAction;
import org.elasticsearch.xpack.slm.action.TransportGetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportGetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.action.TransportPutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportStartSLMAction;
import org.elasticsearch.xpack.slm.action.TransportStopSLMAction;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryStore;
import org.elasticsearch.xpack.slm.history.SnapshotLifecycleTemplateRegistry;

public class SnapshotLifecycle
extends Plugin
implements ActionPlugin,
HealthPlugin {
    public static final List<NamedXContentRegistry.Entry> NAMED_X_CONTENT_ENTRIES = SnapshotLifecycle.xContentEntries();
    private final SetOnce<SnapshotLifecycleService> snapshotLifecycleService = new SetOnce();
    private final SetOnce<SnapshotRetentionService> snapshotRetentionService = new SetOnce();
    private final SetOnce<SnapshotHistoryStore> snapshotHistoryStore = new SetOnce();
    private final SetOnce<SlmHealthIndicatorService> slmHealthIndicatorService = new SetOnce();
    private final Settings settings;

    public SnapshotLifecycle(Settings settings) {
        this.settings = settings;
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING, LifecycleSettings.SLM_RETENTION_SCHEDULE_SETTING, LifecycleSettings.SLM_RETENTION_DURATION_SETTING, LifecycleSettings.SLM_MINIMUM_INTERVAL_SETTING, LifecycleSettings.SLM_HEALTH_FAILED_SNAPSHOT_WARN_THRESHOLD_SETTING);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        Client client = services.client();
        ClusterService clusterService = services.clusterService();
        ThreadPool threadPool = services.threadPool();
        ArrayList components = new ArrayList();
        SnapshotLifecycleTemplateRegistry templateRegistry = new SnapshotLifecycleTemplateRegistry(this.settings, clusterService, threadPool, client, services.xContentRegistry());
        templateRegistry.initialize();
        this.snapshotHistoryStore.set((Object)new SnapshotHistoryStore((Client)new OriginSettingClient(client, "index_lifecycle"), clusterService));
        this.snapshotLifecycleService.set((Object)new SnapshotLifecycleService(this.settings, projectId -> new SnapshotLifecycleTask((ProjectId)projectId, client, clusterService, (SnapshotHistoryStore)this.snapshotHistoryStore.get()), clusterService, this.getClock()));
        ((SnapshotLifecycleService)this.snapshotLifecycleService.get()).init();
        this.snapshotRetentionService.set((Object)new SnapshotRetentionService(this.settings, () -> new SnapshotRetentionTask(client, clusterService, System::nanoTime, (SnapshotHistoryStore)this.snapshotHistoryStore.get()), this.getClock()));
        ((SnapshotRetentionService)this.snapshotRetentionService.get()).init(clusterService);
        Collections.addAll(components, this.snapshotLifecycleService.get(), this.snapshotHistoryStore.get(), this.snapshotRetentionService.get());
        this.slmHealthIndicatorService.set((Object)new SlmHealthIndicatorService(clusterService));
        return components;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return NAMED_X_CONTENT_ENTRIES;
    }

    private static List<NamedXContentRegistry.Entry> xContentEntries() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("snapshot_lifecycle", new String[0]), parser -> (Metadata.ProjectCustom)SnapshotLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("registered_snapshots", new String[0]), RegisteredPolicySnapshots::parse));
    }

    public List<RestHandler> getRestHandlers(Settings unused, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.addAll(Arrays.asList(new BaseRestHandler[]{new RestPutSnapshotLifecycleAction(), new RestDeleteSnapshotLifecycleAction(), new RestGetSnapshotLifecycleAction(), new RestExecuteSnapshotLifecycleAction(), new RestGetSnapshotLifecycleStatsAction(), new RestExecuteSnapshotRetentionAction(), new RestStopSLMAction(), new RestStartSLMAction(), new RestGetSLMStatusAction()}));
        return handlers;
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ActionPlugin.ActionHandler slmUsageAction = new ActionPlugin.ActionHandler(XPackUsageFeatureAction.SNAPSHOT_LIFECYCLE, SLMUsageTransportAction.class);
        ActionPlugin.ActionHandler slmInfoAction = new ActionPlugin.ActionHandler(XPackInfoFeatureAction.SNAPSHOT_LIFECYCLE, SLMInfoTransportAction.class);
        ArrayList<ActionPlugin.ActionHandler> actions = new ArrayList<ActionPlugin.ActionHandler>();
        actions.add(slmUsageAction);
        actions.add(slmInfoAction);
        actions.addAll(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutSnapshotLifecycleAction.INSTANCE, TransportPutSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteSnapshotLifecycleAction.INSTANCE, TransportDeleteSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)GetSnapshotLifecycleAction.INSTANCE, TransportGetSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)ExecuteSnapshotLifecycleAction.INSTANCE, TransportExecuteSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)GetSnapshotLifecycleStatsAction.INSTANCE, TransportGetSnapshotLifecycleStatsAction.class), new ActionPlugin.ActionHandler((ActionType)ExecuteSnapshotRetentionAction.INSTANCE, TransportExecuteSnapshotRetentionAction.class), new ActionPlugin.ActionHandler(TransportSLMGetExpiredSnapshotsAction.INSTANCE, TransportSLMGetExpiredSnapshotsAction.class), new ActionPlugin.ActionHandler((ActionType)StartSLMAction.INSTANCE, TransportStartSLMAction.class), new ActionPlugin.ActionHandler((ActionType)StopSLMAction.INSTANCE, TransportStopSLMAction.class), new ActionPlugin.ActionHandler((ActionType)GetSLMStatusAction.INSTANCE, TransportGetSLMStatusAction.class)));
        return actions;
    }

    List<ReservedClusterStateHandler<?>> reservedClusterStateHandlers() {
        return List.of(new ReservedSnapshotAction());
    }

    public Collection<HealthIndicatorService> getHealthIndicatorServices() {
        return List.of((HealthIndicatorService)this.slmHealthIndicatorService.get());
    }

    public void close() {
        try {
            IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.snapshotLifecycleService.get(), (Closeable)this.snapshotRetentionService.get()});
        }
        catch (IOException e) {
            throw new ElasticsearchException("unable to close snapshot lifecycle services", (Throwable)e, new Object[0]);
        }
    }
}

