/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.xpack.ql.type.DataType;

public final class DataTypes {
    public static final DataType UNSUPPORTED = new DataType("UNSUPPORTED", null, 0, false, false, false);
    public static final DataType NULL = new DataType("null", 0, false, false, false);
    public static final DataType BOOLEAN = new DataType("boolean", 1, false, false, false);
    public static final DataType BYTE = new DataType("byte", 1, true, false, true);
    public static final DataType SHORT = new DataType("short", 2, true, false, true);
    public static final DataType INTEGER = new DataType("integer", 4, true, false, true);
    public static final DataType LONG = new DataType("long", 8, true, false, true);
    public static final DataType UNSIGNED_LONG = new DataType("unsigned_long", 8, true, false, true);
    public static final DataType DOUBLE = new DataType("double", 8, false, true, true);
    public static final DataType FLOAT = new DataType("float", 4, false, true, true);
    public static final DataType HALF_FLOAT = new DataType("half_float", 4, false, true, true);
    public static final DataType SCALED_FLOAT = new DataType("scaled_float", 8, false, true, true);
    public static final DataType KEYWORD = new DataType("keyword", Integer.MAX_VALUE, false, false, true);
    public static final DataType TEXT = new DataType("text", Integer.MAX_VALUE, false, false, false);
    public static final DataType DATETIME = new DataType("DATETIME", "date", 8, false, false, true);
    public static final DataType IP = new DataType("ip", 45, false, false, true);
    public static final DataType VERSION = new DataType("version", Integer.MAX_VALUE, false, false, true);
    public static final DataType BINARY = new DataType("binary", Integer.MAX_VALUE, false, false, true);
    public static final DataType OBJECT = new DataType("object", 0, false, false, false);
    public static final DataType NESTED = new DataType("nested", 0, false, false, false);
    public static final DataType SOURCE = new DataType("_source", "_source", Integer.MAX_VALUE, false, false, false);
    private static final Collection<DataType> TYPES = Stream.of(UNSUPPORTED, NULL, BOOLEAN, BYTE, SHORT, INTEGER, LONG, UNSIGNED_LONG, DOUBLE, FLOAT, HALF_FLOAT, SCALED_FLOAT, KEYWORD, TEXT, DATETIME, IP, VERSION, BINARY, OBJECT, NESTED).sorted(Comparator.comparing(DataType::typeName)).toList();
    private static final Map<String, DataType> NAME_TO_TYPE = TYPES.stream().collect(Collectors.toUnmodifiableMap(DataType::typeName, t -> t));
    private static Map<String, DataType> ES_TO_TYPE;

    private DataTypes() {
    }

    public static Collection<DataType> types() {
        return TYPES;
    }

    public static DataType fromTypeName(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public static DataType fromEs(String name) {
        DataType type = ES_TO_TYPE.get(name);
        return type != null ? type : UNSUPPORTED;
    }

    public static DataType fromJava(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, BigInteger.class, Boolean.class, Double.class, Float.class, Byte.class, Short.class, ZonedDateTime.class, String.class, Character.class}, (Object)object, n)) {
            case -1 -> NULL;
            case 0 -> {
                Integer i = (Integer)object;
                yield INTEGER;
            }
            case 1 -> {
                Long l = (Long)object;
                yield LONG;
            }
            case 2 -> {
                BigInteger bigInteger = (BigInteger)object;
                yield UNSIGNED_LONG;
            }
            case 3 -> {
                Boolean b = (Boolean)object;
                yield BOOLEAN;
            }
            case 4 -> {
                Double v = (Double)object;
                yield DOUBLE;
            }
            case 5 -> {
                Float v = (Float)object;
                yield FLOAT;
            }
            case 6 -> {
                Byte b = (Byte)object;
                yield BYTE;
            }
            case 7 -> {
                Short s = (Short)object;
                yield SHORT;
            }
            case 8 -> {
                ZonedDateTime zonedDateTime = (ZonedDateTime)object;
                yield DATETIME;
            }
            case 9 -> {
                String s = (String)object;
                yield KEYWORD;
            }
            case 10 -> {
                Character c = (Character)object;
                yield KEYWORD;
            }
            default -> null;
        };
    }

    public static boolean isUnsupported(DataType from) {
        return from == UNSUPPORTED;
    }

    public static boolean isString(DataType t) {
        return t == KEYWORD || t == TEXT;
    }

    public static boolean isPrimitive(DataType t) {
        return t != OBJECT && t != NESTED && t != UNSUPPORTED;
    }

    public static boolean isNull(DataType t) {
        return t == NULL;
    }

    public static boolean isNullOrNumeric(DataType t) {
        return t.isNumeric() || DataTypes.isNull(t);
    }

    public static boolean isSigned(DataType t) {
        return t.isNumeric() && !t.equals(UNSIGNED_LONG);
    }

    public static boolean isDateTime(DataType type) {
        return type == DATETIME;
    }

    public static boolean areCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == NULL || right == NULL || DataTypes.isString(left) && DataTypes.isString(right) || left.isNumeric() && right.isNumeric() || DataTypes.isDateTime(left) && DataTypes.isDateTime(right);
    }

    static {
        Map<String, DataType> map = TYPES.stream().filter(e -> e.esType() != null).collect(Collectors.toMap(DataType::esType, t -> t));
        map.put("date_nanos", DATETIME);
        ES_TO_TYPE = Collections.unmodifiableMap(map);
    }
}

