/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.AggregateMetricFieldValueFetcher;
import org.elasticsearch.xpack.downsample.LabelFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

class FieldValueFetcher {
    protected final String name;
    protected final MappedFieldType fieldType;
    protected final IndexFieldData<?> fieldData;
    protected final AbstractDownsampleFieldProducer fieldProducer;

    protected FieldValueFetcher(String name, MappedFieldType fieldType, IndexFieldData<?> fieldData) {
        this.name = name;
        this.fieldType = fieldType;
        this.fieldData = fieldData;
        this.fieldProducer = this.createFieldProducer();
    }

    public String name() {
        return this.name;
    }

    public FormattedDocValues getLeaf(LeafReaderContext context) {
        DocValueFormat format = this.fieldType.docValueFormat(null, null);
        return this.fieldData.load(context).getFormattedValues(format);
    }

    public SortedNumericDoubleValues getNumericLeaf(LeafReaderContext context) {
        LeafNumericFieldData numericFieldData = (LeafNumericFieldData)this.fieldData.load(context);
        return numericFieldData.getDoubleValues();
    }

    AbstractDownsampleFieldProducer fieldProducer() {
        return this.fieldProducer;
    }

    private AbstractDownsampleFieldProducer createFieldProducer() {
        if (this.fieldType.getMetricType() != null) {
            return switch (this.fieldType.getMetricType()) {
                default -> throw new MatchException(null, null);
                case TimeSeriesParams.MetricType.GAUGE -> new MetricFieldProducer.GaugeMetricFieldProducer(this.name());
                case TimeSeriesParams.MetricType.COUNTER -> new MetricFieldProducer.CounterMetricFieldProducer(this.name());
                case TimeSeriesParams.MetricType.POSITION -> throw new IllegalArgumentException("Unsupported metric type [position] for down-sampling");
            };
        }
        if ("histogram".equals(this.fieldType.typeName())) {
            return new LabelFieldProducer.HistogramLastLabelFieldProducer(this.name());
        }
        if ("flattened".equals(this.fieldType.typeName())) {
            return new LabelFieldProducer.FlattenedLastValueFieldProducer(this.name());
        }
        return new LabelFieldProducer.LabelLastValueFieldProducer(this.name());
    }

    static List<FieldValueFetcher> create(SearchExecutionContext context, String[] fields, Map<String, String> multiFieldSources) {
        ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>();
        for (String field : fields) {
            IndexFieldData fieldData;
            String sourceField = multiFieldSources.getOrDefault(field, field);
            MappedFieldType fieldType = context.getFieldType(sourceField);
            assert (fieldType != null) : "Unknown field type for field: [" + sourceField + "]";
            if (fieldType instanceof AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType) {
                AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType = (AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType)fieldType;
                for (NumberFieldMapper.NumberFieldType metricSubField : aggMetricFieldType.getMetricFields().values()) {
                    if (!context.fieldExistsInIndex(metricSubField.name())) continue;
                    IndexFieldData fieldData2 = context.getForField((MappedFieldType)metricSubField, MappedFieldType.FielddataOperation.SEARCH);
                    fetchers.add(new AggregateMetricFieldValueFetcher((MappedFieldType)metricSubField, aggMetricFieldType, fieldData2));
                }
                continue;
            }
            if (!context.fieldExistsInIndex(fieldType.name())) continue;
            if (fieldType instanceof FlattenedFieldMapper.RootFlattenedFieldType) {
                FlattenedFieldMapper.RootFlattenedFieldType flattenedFieldType = (FlattenedFieldMapper.RootFlattenedFieldType)fieldType;
                MappedFieldType keyedFieldType = flattenedFieldType.getKeyedFieldType();
                fieldData = context.getForField(keyedFieldType, MappedFieldType.FielddataOperation.SEARCH);
            } else {
                fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            }
            fetchers.add(new FieldValueFetcher(field, fieldType, fieldData));
        }
        return Collections.unmodifiableList(fetchers);
    }
}

