/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.support.TimeSeriesIndexSearcher;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.downsample.DownsampleAfterBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBeforeBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleIndexerAction;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.core.downsample.DownsampleShardTask;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.AggregateMetricFieldSerializer;
import org.elasticsearch.xpack.downsample.DimensionFieldValueFetcher;
import org.elasticsearch.xpack.downsample.DownsampleFieldSerializer;
import org.elasticsearch.xpack.downsample.DownsampleMetrics;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexerException;
import org.elasticsearch.xpack.downsample.FieldValueFetcher;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

class DownsampleShardIndexer {
    private static final Logger logger = LogManager.getLogger(DownsampleShardIndexer.class);
    private static final int DOCID_BUFFER_SIZE = 8096;
    public static final int DOWNSAMPLE_BULK_ACTIONS = 10000;
    public static final ByteSizeValue DOWNSAMPLE_BULK_SIZE = ByteSizeValue.of((long)1L, (ByteSizeUnit)ByteSizeUnit.MB);
    public static final ByteSizeValue DOWNSAMPLE_MAX_BYTES_IN_FLIGHT = ByteSizeValue.of((long)50L, (ByteSizeUnit)ByteSizeUnit.MB);
    private final IndexShard indexShard;
    private final Client client;
    private final DownsampleMetrics downsampleMetrics;
    private final String downsampleIndex;
    private final Engine.Searcher searcher;
    private final SearchExecutionContext searchExecutionContext;
    private final DateFieldMapper.DateFieldType timestampField;
    private final DocValueFormat timestampFormat;
    private final Rounding.Prepared rounding;
    private final List<FieldValueFetcher> fieldValueFetchers;
    private final DownsampleShardTask task;
    private final DownsampleShardPersistentTaskState state;
    private final String[] dimensions;
    private volatile boolean abort = false;
    ByteSizeValue downsampleBulkSize = DOWNSAMPLE_BULK_SIZE;
    ByteSizeValue downsampleMaxBytesInFlight = DOWNSAMPLE_MAX_BYTES_IN_FLIGHT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownsampleShardIndexer(DownsampleShardTask task, Client client, IndexService indexService, DownsampleMetrics downsampleMetrics, ShardId shardId, String downsampleIndex, DownsampleConfig config, String[] metrics, String[] labels, String[] dimensions, Map<String, String> multiFieldSources, DownsampleShardPersistentTaskState state) {
        this.task = task;
        this.client = client;
        this.downsampleMetrics = downsampleMetrics;
        this.indexShard = indexService.getShard(shardId.id());
        this.downsampleIndex = downsampleIndex;
        this.searcher = this.indexShard.acquireSearcher("downsampling");
        this.state = state;
        Engine.Searcher toClose = this.searcher;
        try {
            this.searchExecutionContext = indexService.newSearchExecutionContext(this.indexShard.shardId().id(), 0, (IndexSearcher)this.searcher, () -> 0L, null, Collections.emptyMap());
            this.dimensions = dimensions;
            this.timestampField = (DateFieldMapper.DateFieldType)this.searchExecutionContext.getFieldType(config.getTimestampField());
            this.timestampFormat = this.timestampField.docValueFormat(null, null);
            this.rounding = config.createRounding();
            ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>(metrics.length + labels.length + dimensions.length);
            fetchers.addAll(FieldValueFetcher.create(this.searchExecutionContext, metrics, multiFieldSources));
            fetchers.addAll(FieldValueFetcher.create(this.searchExecutionContext, labels, multiFieldSources));
            fetchers.addAll(DimensionFieldValueFetcher.create(this.searchExecutionContext, dimensions, multiFieldSources));
            this.fieldValueFetchers = Collections.unmodifiableList(fetchers);
            toClose = null;
        }
        finally {
            IOUtils.closeWhileHandlingException((Closeable)toClose);
        }
    }

    public DownsampleIndexerAction.ShardDownsampleResponse execute() throws IOException {
        String error;
        Query initialStateQuery = this.createQuery();
        if (initialStateQuery instanceof MatchNoDocsQuery) {
            return new DownsampleIndexerAction.ShardDownsampleResponse(this.indexShard.shardId(), this.task.getNumIndexed());
        }
        long startTime = this.client.threadPool().relativeTimeInMillis();
        this.task.setTotalShardDocCount(this.searcher.getDirectoryReader().numDocs());
        this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.STARTED);
        this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.STARTED, null), ActionListener.noop());
        logger.info("Downsampling task [" + this.task.getPersistentTaskId() + " on shard " + String.valueOf(this.indexShard.shardId()) + " started");
        BulkProcessor2 bulkProcessor = this.createBulkProcessor();
        try (Engine.Searcher searcher = this.searcher;
             BulkProcessor2 bulkProcessor2 = bulkProcessor;){
            TimeSeriesIndexSearcher timeSeriesSearcher = new TimeSeriesIndexSearcher((IndexSearcher)this.searcher, List.of(this::checkCancelled));
            TimeSeriesBucketCollector bucketCollector = new TimeSeriesBucketCollector(bulkProcessor, this.dimensions);
            bucketCollector.preCollection();
            timeSeriesSearcher.search(initialStateQuery, (BucketCollector)bucketCollector);
        }
        TimeValue duration = TimeValue.timeValueMillis((long)(this.client.threadPool().relativeTimeInMillis() - startTime));
        logger.info("Shard [{}] successfully sent [{}], received source doc [{}], indexed downsampled doc [{}], failed [{}], took [{}]", (Object)this.indexShard.shardId(), (Object)this.task.getNumReceived(), (Object)this.task.getNumSent(), (Object)this.task.getNumIndexed(), (Object)this.task.getNumFailed(), (Object)duration);
        if (this.task.getNumIndexed() != this.task.getNumSent()) {
            this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.FAILED);
            error = "Downsampling task [" + this.task.getPersistentTaskId() + "] on shard " + String.valueOf(this.indexShard.shardId()) + " failed indexing,  indexed [" + this.task.getNumIndexed() + "] sent [" + this.task.getNumSent() + "]";
            logger.info(error);
            this.downsampleMetrics.recordShardOperation(duration.millis(), DownsampleMetrics.ActionStatus.MISSING_DOCS);
            throw new DownsampleShardIndexerException(error, false);
        }
        if (this.task.getNumFailed() > 0L) {
            error = "Downsampling task [" + this.task.getPersistentTaskId() + "] on shard " + String.valueOf(this.indexShard.shardId()) + " failed indexing [" + this.task.getNumFailed() + "]";
            logger.info(error);
            this.downsampleMetrics.recordShardOperation(duration.millis(), DownsampleMetrics.ActionStatus.FAILED);
            throw new DownsampleShardIndexerException(error, false);
        }
        this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.COMPLETED);
        this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.COMPLETED, null), ActionListener.noop());
        logger.info("Downsampling task [" + this.task.getPersistentTaskId() + " on shard " + String.valueOf(this.indexShard.shardId()) + " completed");
        this.downsampleMetrics.recordShardOperation(duration.millis(), DownsampleMetrics.ActionStatus.SUCCESS);
        return new DownsampleIndexerAction.ShardDownsampleResponse(this.indexShard.shardId(), this.task.getNumIndexed());
    }

    private Query createQuery() {
        if (this.state.started() && this.state.tsid() != null) {
            return SortedSetDocValuesField.newSlowRangeQuery((String)"_tsid", (BytesRef)this.state.tsid(), null, (boolean)true, (boolean)false);
        }
        return new MatchAllDocsQuery();
    }

    private void checkCancelled() {
        if (this.task.isCancelled()) {
            logger.warn("Shard [{}] downsampled abort, sent [{}], indexed [{}], failed[{}]", (Object)this.indexShard.shardId(), (Object)this.task.getNumSent(), (Object)this.task.getNumIndexed(), (Object)this.task.getNumFailed());
            this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.CANCELLED);
            this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.CANCELLED, null), ActionListener.noop());
            logger.info("Downsampling task [" + this.task.getPersistentTaskId() + "] on shard " + String.valueOf(this.indexShard.shardId()) + " cancelled");
            throw new DownsampleShardIndexerException((Throwable)new TaskCancelledException(Strings.format((String)"Shard %s downsample cancelled", (Object[])new Object[]{this.indexShard.shardId()})), Strings.format((String)"Shard %s downsample cancelled", (Object[])new Object[]{this.indexShard.shardId()}), false);
        }
        if (this.abort) {
            logger.warn("Shard [{}] downsample abort, sent [{}], indexed [{}], failed[{}]", (Object)this.indexShard.shardId(), (Object)this.task.getNumSent(), (Object)this.task.getNumIndexed(), (Object)this.task.getNumFailed());
            this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.FAILED);
            this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.FAILED, null), ActionListener.noop());
            throw new DownsampleShardIndexerException("Bulk indexing failure", true);
        }
    }

    private BulkProcessor2 createBulkProcessor() {
        BulkProcessor2.Listener listener = new BulkProcessor2.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                DownsampleShardIndexer.this.task.addNumSent((long)request.numberOfActions());
                DownsampleShardIndexer.this.task.setBeforeBulkInfo(new DownsampleBeforeBulkInfo(DownsampleShardIndexer.this.client.threadPool().absoluteTimeInMillis(), executionId, request.estimatedSizeInBytes(), request.numberOfActions()));
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long bulkIngestTookMillis = response.getIngestTookInMillis() >= 0L ? response.getIngestTookInMillis() : 0L;
                long bulkTookMillis = response.getTook().getMillis();
                DownsampleShardIndexer.this.task.addNumIndexed((long)request.numberOfActions());
                DownsampleShardIndexer.this.task.setAfterBulkInfo(new DownsampleAfterBulkInfo(DownsampleShardIndexer.this.client.threadPool().absoluteTimeInMillis(), executionId, bulkIngestTookMillis, bulkTookMillis, response.hasFailures(), RestStatus.OK.getStatus()));
                DownsampleShardIndexer.this.task.updateBulkInfo(bulkIngestTookMillis, bulkTookMillis);
                if (response.hasFailures()) {
                    List<BulkItemResponse> failedItems = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).toList();
                    DownsampleShardIndexer.this.task.addNumFailed((long)failedItems.size());
                    Map<String, String> failures = failedItems.stream().collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage, (msg1, msg2) -> Objects.equals(msg1, msg2) ? msg1 : msg1 + "," + msg2));
                    logger.error("Shard [{}] failed to populate downsample index. Failures: [{}]", (Object)DownsampleShardIndexer.this.indexShard.shardId(), failures);
                    DownsampleShardIndexer.this.abort = true;
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Exception failure) {
                if (failure != null) {
                    long items = request.numberOfActions();
                    DownsampleShardIndexer.this.task.addNumFailed(items);
                    logger.error(() -> Strings.format((String)"Shard [%s] failed to populate downsample index.", (Object[])new Object[]{DownsampleShardIndexer.this.indexShard.shardId()}), (Throwable)failure);
                    DownsampleShardIndexer.this.abort = true;
                }
            }
        };
        return BulkProcessor2.builder((arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1), (BulkProcessor2.Listener)listener, (ThreadPool)this.client.threadPool()).setBulkActions(10000).setBulkSize(DOWNSAMPLE_BULK_SIZE).setMaxBytesInFlight(this.downsampleMaxBytesInFlight).setMaxNumberOfRetries(3).build();
    }

    private class TimeSeriesBucketCollector
    extends BucketCollector {
        private final BulkProcessor2 bulkProcessor;
        private final DownsampleBucketBuilder downsampleBucketBuilder;
        private final List<LeafDownsampleCollector> leafBucketCollectors = new ArrayList<LeafDownsampleCollector>();
        private long docsProcessed;
        private long bucketsCreated;
        long lastTimestamp = Long.MAX_VALUE;
        long lastHistoTimestamp = Long.MAX_VALUE;

        TimeSeriesBucketCollector(BulkProcessor2 bulkProcessor, String[] dimensions) {
            this.bulkProcessor = bulkProcessor;
            AbstractDownsampleFieldProducer[] fieldProducers = (AbstractDownsampleFieldProducer[])DownsampleShardIndexer.this.fieldValueFetchers.stream().map(FieldValueFetcher::fieldProducer).toArray(AbstractDownsampleFieldProducer[]::new);
            this.downsampleBucketBuilder = new DownsampleBucketBuilder(fieldProducers, dimensions);
        }

        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) throws IOException {
            LeafReaderContext ctx = aggCtx.getLeafReaderContext();
            DocCountProvider docCountProvider = new DocCountProvider();
            docCountProvider.setLeafReaderContext(ctx);
            ArrayList<AbstractDownsampleFieldProducer> nonMetricProducers = new ArrayList<AbstractDownsampleFieldProducer>();
            ArrayList<FormattedDocValues> formattedDocValues = new ArrayList<FormattedDocValues>();
            ArrayList<MetricFieldProducer> metricProducers = new ArrayList<MetricFieldProducer>();
            ArrayList<SortedNumericDoubleValues> numericDocValues = new ArrayList<SortedNumericDoubleValues>();
            for (FieldValueFetcher fieldValueFetcher : DownsampleShardIndexer.this.fieldValueFetchers) {
                AbstractDownsampleFieldProducer fieldProducer = fieldValueFetcher.fieldProducer();
                if (fieldProducer instanceof MetricFieldProducer) {
                    MetricFieldProducer metricFieldProducer = (MetricFieldProducer)fieldProducer;
                    metricProducers.add(metricFieldProducer);
                    numericDocValues.add(fieldValueFetcher.getNumericLeaf(ctx));
                    continue;
                }
                nonMetricProducers.add(fieldProducer);
                formattedDocValues.add(fieldValueFetcher.getLeaf(ctx));
            }
            LeafDownsampleCollector leafBucketCollector = new LeafDownsampleCollector(aggCtx, docCountProvider, nonMetricProducers.toArray(new AbstractDownsampleFieldProducer[0]), formattedDocValues.toArray(new FormattedDocValues[0]), metricProducers.toArray(new MetricFieldProducer[0]), numericDocValues.toArray(new SortedNumericDoubleValues[0]));
            this.leafBucketCollectors.add(leafBucketCollector);
            return leafBucketCollector;
        }

        void bulkCollection() throws IOException {
            this.leafBucketCollectors.sort((o1, o2) -> -Long.compare(o1.firstTimeStampForBulkCollection, o2.firstTimeStampForBulkCollection));
            for (LeafDownsampleCollector leafBucketCollector : this.leafBucketCollectors) {
                leafBucketCollector.leafBulkCollection();
            }
        }

        private void indexBucket(XContentBuilder doc) {
            IndexRequestBuilder request = DownsampleShardIndexer.this.client.prepareIndex(DownsampleShardIndexer.this.downsampleIndex);
            request.setSource(doc);
            if (logger.isTraceEnabled()) {
                logger.trace("Indexing downsample doc: [{}]", (Object)org.elasticsearch.common.Strings.toString((XContentBuilder)doc));
            }
            IndexRequest indexRequest = request.request();
            DownsampleShardIndexer.this.task.setLastIndexingTimestamp(System.currentTimeMillis());
            this.bulkProcessor.addWithBackpressure(indexRequest, () -> DownsampleShardIndexer.this.abort);
        }

        public void preCollection() {
            DownsampleShardIndexer.this.checkCancelled();
        }

        public void postCollection() throws IOException {
            this.bulkCollection();
            if (!this.downsampleBucketBuilder.isEmpty()) {
                XContentBuilder doc = this.downsampleBucketBuilder.buildDownsampleDocument();
                this.indexBucket(doc);
            }
            DownsampleShardIndexer.this.checkCancelled();
            logger.info("Shard {} processed [{}] docs, created [{}] downsample buckets", (Object)DownsampleShardIndexer.this.indexShard.shardId(), (Object)this.docsProcessed, (Object)this.bucketsCreated);
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }

        class LeafDownsampleCollector
        extends LeafBucketCollector {
            final AggregationExecutionContext aggCtx;
            final DocCountProvider docCountProvider;
            final FormattedDocValues[] formattedDocValues;
            final AbstractDownsampleFieldProducer[] nonMetricProducers;
            final MetricFieldProducer[] metricProducers;
            final SortedNumericDoubleValues[] numericDocValues;
            long firstTimeStampForBulkCollection;
            final IntArrayList docIdBuffer = new IntArrayList(8096);
            final long timestampBoundStartTime;

            LeafDownsampleCollector(AggregationExecutionContext aggCtx, DocCountProvider docCountProvider, AbstractDownsampleFieldProducer[] nonMetricProducers, FormattedDocValues[] formattedDocValues, MetricFieldProducer[] metricProducers, SortedNumericDoubleValues[] numericDocValues) {
                this.timestampBoundStartTime = DownsampleShardIndexer.this.searchExecutionContext.getIndexSettings().getTimestampBounds().startTime();
                assert (nonMetricProducers.length == formattedDocValues.length);
                assert (metricProducers.length == numericDocValues.length);
                this.aggCtx = aggCtx;
                this.docCountProvider = docCountProvider;
                this.nonMetricProducers = nonMetricProducers;
                this.formattedDocValues = formattedDocValues;
                this.metricProducers = metricProducers;
                this.numericDocValues = numericDocValues;
            }

            public void collect(int docId, long owningBucketOrd) throws IOException {
                boolean tsidChanged;
                DownsampleShardIndexer.this.task.addNumReceived(1L);
                BytesRef tsidHash = this.aggCtx.getTsidHash();
                assert (tsidHash != null) : "Document without [_tsid] field was found.";
                int tsidHashOrd = this.aggCtx.getTsidHashOrd();
                long timestamp = DownsampleShardIndexer.this.timestampField.resolution().roundDownToMillis(this.aggCtx.getTimestamp());
                boolean bl = tsidChanged = tsidHashOrd != TimeSeriesBucketCollector.this.downsampleBucketBuilder.tsidOrd();
                if (tsidChanged || timestamp < TimeSeriesBucketCollector.this.lastHistoTimestamp) {
                    TimeSeriesBucketCollector.this.lastHistoTimestamp = Math.max(DownsampleShardIndexer.this.rounding.round(timestamp), this.timestampBoundStartTime);
                }
                DownsampleShardIndexer.this.task.setLastSourceTimestamp(timestamp);
                DownsampleShardIndexer.this.task.setLastTargetTimestamp(TimeSeriesBucketCollector.this.lastHistoTimestamp);
                if (logger.isTraceEnabled()) {
                    logger.trace("Doc: [{}] - _tsid: [{}], @timestamp: [{}] -> downsample bucket ts: [{}]", (Object)docId, DocValueFormat.TIME_SERIES_ID.format(tsidHash), DownsampleShardIndexer.this.timestampFormat.format(timestamp), DownsampleShardIndexer.this.timestampFormat.format(TimeSeriesBucketCollector.this.lastHistoTimestamp));
                }
                assert (this.assertTsidAndTimestamp(tsidHash, timestamp));
                TimeSeriesBucketCollector.this.lastTimestamp = timestamp;
                if (tsidChanged || TimeSeriesBucketCollector.this.downsampleBucketBuilder.timestamp() != TimeSeriesBucketCollector.this.lastHistoTimestamp) {
                    TimeSeriesBucketCollector.this.bulkCollection();
                    if (!TimeSeriesBucketCollector.this.downsampleBucketBuilder.isEmpty()) {
                        XContentBuilder doc = TimeSeriesBucketCollector.this.downsampleBucketBuilder.buildDownsampleDocument();
                        TimeSeriesBucketCollector.this.indexBucket(doc);
                    }
                    if (tsidChanged) {
                        TimeSeriesBucketCollector.this.downsampleBucketBuilder.resetTsid(tsidHash, tsidHashOrd, TimeSeriesBucketCollector.this.lastHistoTimestamp);
                    } else {
                        TimeSeriesBucketCollector.this.downsampleBucketBuilder.resetTimestamp(TimeSeriesBucketCollector.this.lastHistoTimestamp);
                    }
                    ++TimeSeriesBucketCollector.this.bucketsCreated;
                }
                if (this.docIdBuffer.isEmpty()) {
                    this.firstTimeStampForBulkCollection = this.aggCtx.getTimestamp();
                }
                this.docIdBuffer.buffer[this.docIdBuffer.elementsCount++] = docId;
                if (this.docIdBuffer.size() == 8096) {
                    TimeSeriesBucketCollector.this.bulkCollection();
                }
            }

            void leafBulkCollection() throws IOException {
                int i;
                if (this.docIdBuffer.isEmpty()) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("buffered {} docids", (Object)this.docIdBuffer.size());
                }
                TimeSeriesBucketCollector.this.downsampleBucketBuilder.collectDocCount(this.docIdBuffer, this.docCountProvider);
                for (i = 0; i < this.nonMetricProducers.length; ++i) {
                    AbstractDownsampleFieldProducer fieldProducer = this.nonMetricProducers[i];
                    FormattedDocValues docValues = this.formattedDocValues[i];
                    fieldProducer.collect(docValues, this.docIdBuffer);
                }
                for (i = 0; i < this.metricProducers.length; ++i) {
                    MetricFieldProducer metricFieldProducer = this.metricProducers[i];
                    SortedNumericDoubleValues numericDoubleValues = this.numericDocValues[i];
                    metricFieldProducer.collect(numericDoubleValues, this.docIdBuffer);
                }
                TimeSeriesBucketCollector.this.docsProcessed += (long)this.docIdBuffer.size();
                DownsampleShardIndexer.this.task.setDocsProcessed(TimeSeriesBucketCollector.this.docsProcessed);
                this.docIdBuffer.elementsCount = 0;
            }

            boolean assertTsidAndTimestamp(BytesRef tsidHash, long timestamp) {
                BytesRef lastTsid = TimeSeriesBucketCollector.this.downsampleBucketBuilder.tsid();
                assert (lastTsid == null || lastTsid.compareTo(tsidHash) <= 0) : "_tsid is not sorted in ascending order: [" + String.valueOf(DocValueFormat.TIME_SERIES_ID.format(lastTsid)) + "] -> [" + String.valueOf(DocValueFormat.TIME_SERIES_ID.format(tsidHash)) + "]";
                assert (!tsidHash.equals((Object)lastTsid) || TimeSeriesBucketCollector.this.lastTimestamp >= timestamp) : "@timestamp is not sorted in descending order: [" + String.valueOf(DownsampleShardIndexer.this.timestampFormat.format(TimeSeriesBucketCollector.this.lastTimestamp)) + "] -> [" + String.valueOf(DownsampleShardIndexer.this.timestampFormat.format(timestamp)) + "]";
                return true;
            }
        }
    }

    private class DownsampleBucketBuilder {
        private BytesRef tsid;
        private int tsidOrd = -1;
        private long timestamp;
        private int docCount;
        private final AbstractDownsampleFieldProducer[] fieldProducers;
        private final DownsampleFieldSerializer[] groupedProducers;
        private final String[] dimensions;

        DownsampleBucketBuilder(AbstractDownsampleFieldProducer[] fieldProducers, String[] dimensions) {
            this.fieldProducers = fieldProducers;
            this.dimensions = dimensions;
            this.groupedProducers = (DownsampleFieldSerializer[])Arrays.stream(fieldProducers).collect(Collectors.groupingBy(AbstractDownsampleFieldProducer::name)).entrySet().stream().map(e -> {
                if (((List)e.getValue()).size() == 1) {
                    return (DownsampleFieldSerializer)((List)e.getValue()).get(0);
                }
                return new AggregateMetricFieldSerializer((String)e.getKey(), (Collection)e.getValue());
            }).toArray(DownsampleFieldSerializer[]::new);
        }

        public void resetTsid(BytesRef tsid, int tsidOrd, long timestamp) {
            this.tsid = BytesRef.deepCopyOf((BytesRef)tsid);
            this.tsidOrd = tsidOrd;
            this.resetTimestamp(timestamp);
        }

        public void resetTimestamp(long timestamp) {
            this.timestamp = timestamp;
            this.docCount = 0;
            for (AbstractDownsampleFieldProducer producer : this.fieldProducers) {
                producer.reset();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("New bucket for _tsid: [{}], @timestamp: [{}]", DocValueFormat.TIME_SERIES_ID.format(this.tsid), DownsampleShardIndexer.this.timestampFormat.format(timestamp));
            }
        }

        public void collectDocCount(IntArrayList buffer, DocCountProvider docCountProvider) throws IOException {
            if (docCountProvider.alwaysOne()) {
                this.docCount += buffer.size();
            } else {
                for (int i = 0; i < buffer.size(); ++i) {
                    int docId = buffer.get(i);
                    this.docCount += docCountProvider.getDocCount(docId);
                }
            }
        }

        public XContentBuilder buildDownsampleDocument() throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.SMILE);
            builder.startObject();
            if (this.isEmpty()) {
                builder.endObject();
                return builder;
            }
            builder.field(DownsampleShardIndexer.this.timestampField.name(), DownsampleShardIndexer.this.timestampFormat.format(this.timestamp));
            builder.field("_doc_count", this.docCount);
            for (DownsampleFieldSerializer fieldProducer : this.groupedProducers) {
                fieldProducer.write(builder);
            }
            if (this.dimensions.length == 0) {
                logger.debug("extracting dimensions from legacy tsid");
                Map dimensions = (Map)DocValueFormat.TIME_SERIES_ID.format(this.tsid);
                for (Map.Entry e : dimensions.entrySet()) {
                    assert (e.getValue() != null);
                    builder.field((String)e.getKey(), e.getValue());
                }
            }
            builder.endObject();
            return builder;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public BytesRef tsid() {
            return this.tsid;
        }

        public int tsidOrd() {
            return this.tsidOrd;
        }

        public int docCount() {
            return this.docCount;
        }

        public boolean isEmpty() {
            return this.tsid() == null || this.timestamp() == 0L || this.docCount() == 0;
        }
    }
}

