/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.IRDecorations;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.objectweb.asm.util.Printer;

public class ClassNode
extends IRNode {
    private final List<FieldNode> fieldNodes = new ArrayList<FieldNode>();
    private final List<FunctionNode> functionNodes = new ArrayList<FunctionNode>();
    private final BlockNode clinitBlockNode = new BlockNode(new Location("internal$clinit$blocknode", 0));
    private Printer debugStream;
    private ScriptScope scriptScope;
    private byte[] bytes;

    public void addFieldNode(FieldNode fieldNode) {
        this.fieldNodes.add(fieldNode);
    }

    public List<FieldNode> getFieldsNodes() {
        return this.fieldNodes;
    }

    public void addFunctionNode(FunctionNode functionNode) {
        this.functionNodes.add(functionNode);
    }

    public List<FunctionNode> getFunctionsNodes() {
        return this.functionNodes;
    }

    public BlockNode getClinitBlockNode() {
        return this.clinitBlockNode;
    }

    public void setDebugStream(Printer debugStream) {
        this.debugStream = debugStream;
    }

    public Printer getDebugStream() {
        return this.debugStream;
    }

    public void setScriptScope(ScriptScope scriptScope) {
        this.scriptScope = scriptScope;
    }

    public ScriptScope getScriptScope() {
        return this.scriptScope;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitClass(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.clinitBlockNode.visit(irTreeVisitor, scope);
        for (FunctionNode functionNode : this.functionNodes) {
            functionNode.visit(irTreeVisitor, scope);
        }
    }

    public ClassNode(Location location) {
        super(location);
        this.clinitBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
    }
}

