/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;

public interface SemanticTextUtils {
    public static List<String> nodeStringValues(String field, Object valueObj) {
        if (valueObj instanceof Number || valueObj instanceof Boolean) {
            return List.of(valueObj.toString());
        }
        if (valueObj instanceof String) {
            String value = (String)valueObj;
            return List.of(value);
        }
        if (valueObj instanceof Collection) {
            Collection values = (Collection)valueObj;
            ArrayList<String> valuesString = new ArrayList<String>();
            for (Object v : values) {
                if (v instanceof Number || v instanceof Boolean) {
                    valuesString.add(v.toString());
                    continue;
                }
                if (v instanceof String) {
                    String value = (String)v;
                    valuesString.add(value);
                    continue;
                }
                throw new ElasticsearchStatusException("Invalid format for field [{}], expected [String|Number|Boolean] got [{}]", RestStatus.BAD_REQUEST, new Object[]{field, valueObj.getClass().getSimpleName()});
            }
            return valuesString;
        }
        throw new ElasticsearchStatusException("Invalid format for field [{}], expected [String|Number|Boolean] got [{}]", RestStatus.BAD_REQUEST, new Object[]{field, valueObj.getClass().getSimpleName()});
    }
}

