/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LocateEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LocateNoStartEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Locate
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Locate", Locate::new);
    private final Expression str;
    private final Expression substr;
    private final Expression start;

    @FunctionInfo(returnType={"integer"}, description="Returns an integer that indicates the position of a keyword substring within another string.\nReturns `0` if the substring cannot be found.\nNote that string positions start from `1`.", examples={@Example(file="string", tag="locate")})
    public Locate(Source source, @Param(name="string", type={"keyword", "text"}, description="An input string") Expression str, @Param(name="substring", type={"keyword", "text"}, description="A substring to locate in the input string") Expression substr, @Param(optional=true, name="start", type={"integer"}, description="The start index") Expression start) {
        super(source, start == null ? Arrays.asList(str, substr) : Arrays.asList(str, substr, start));
        this.str = str;
        this.substr = substr;
        this.start = start;
    }

    private Locate(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.str);
        out.writeNamedWriteable((NamedWriteable)this.substr);
        out.writeOptionalNamedWriteable((NamedWriteable)this.start);
    }

    public String getWriteableName() {
        return Locate.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.INTEGER;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString((Expression)this.substr, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.start == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isType((Expression)this.start, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD, (String[])new String[]{"integer"});
    }

    public boolean foldable() {
        return this.str.foldable() && this.substr.foldable() && (this.start == null || this.start.foldable());
    }

    static int process(BytesRef str, BytesRef substr, int start) {
        if (str == null || substr == null || str.length < substr.length) {
            return 0;
        }
        int codePointCount = UnicodeUtil.codePointCount((BytesRef)str);
        int indexStart = Locate.indexStart(codePointCount, start);
        String utf8ToString = str.utf8ToString();
        int idx = utf8ToString.indexOf(substr.utf8ToString(), utf8ToString.offsetByCodePoints(0, indexStart));
        if (idx == -1) {
            return 0;
        }
        return 1 + utf8ToString.codePointCount(0, idx);
    }

    static int process(BytesRef str, BytesRef substr) {
        return Locate.process(str, substr, 0);
    }

    private static int indexStart(int codePointCount, int start) {
        int indexStart = start > 0 ? start - 1 : (start < 0 ? codePointCount + start : start);
        return Math.min(Math.max(0, indexStart), codePointCount);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Locate(this.source(), newChildren.get(0), newChildren.get(1), this.start == null ? null : newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Locate::new, (Object)this.str, (Object)this.substr, (Object)this.start);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strExpr = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory substrExpr = toEvaluator.apply(this.substr);
        if (this.start == null) {
            return new LocateNoStartEvaluator.Factory(this.source(), strExpr, substrExpr);
        }
        return new LocateEvaluator.Factory(this.source(), strExpr, substrExpr, toEvaluator.apply(this.start));
    }

    Expression str() {
        return this.str;
    }

    Expression substr() {
        return this.substr;
    }

    Expression start() {
        return this.start;
    }
}

