/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gpu.codec;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.gpu.codec.CuVSResourceManager;
import org.elasticsearch.gpu.codec.ES92GpuHnswVectorsWriter;

public class ES92GpuHnswVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "Lucene99HnswVectorsFormat";
    public static final int VERSION_GROUPVARINT = 1;
    static final String LUCENE99_HNSW_META_CODEC_NAME = "Lucene99HnswVectorsFormatMeta";
    static final String LUCENE99_HNSW_VECTOR_INDEX_CODEC_NAME = "Lucene99HnswVectorsFormatIndex";
    static final String LUCENE99_HNSW_META_EXTENSION = "vem";
    static final String LUCENE99_HNSW_VECTOR_INDEX_EXTENSION = "vex";
    static final int LUCENE99_VERSION_CURRENT = 1;
    public static final int DEFAULT_MAX_CONN = 12;
    public static final int DEFAULT_BEAM_WIDTH = 22;
    static final int MIN_NUM_VECTORS_FOR_GPU_BUILD = 2;
    private static final FlatVectorsFormat flatVectorsFormat = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private final int maxConn;
    private final int beamWidth;
    private final Supplier<CuVSResourceManager> cuVSResourceManagerSupplier;

    public ES92GpuHnswVectorsFormat() {
        this(CuVSResourceManager::pooling, 12, 22);
    }

    public ES92GpuHnswVectorsFormat(int maxConn, int beamWidth) {
        this(CuVSResourceManager::pooling, maxConn, beamWidth);
    }

    public ES92GpuHnswVectorsFormat(Supplier<CuVSResourceManager> cuVSResourceManagerSupplier, int maxConn, int beamWidth) {
        super(NAME);
        this.cuVSResourceManagerSupplier = cuVSResourceManagerSupplier;
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES92GpuHnswVectorsWriter(this.cuVSResourceManagerSupplier.get(), state, this.maxConn, this.beamWidth, flatVectorsFormat.fieldsWriter(state));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, flatVectorsFormat.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "Lucene99HnswVectorsFormat(name=Lucene99HnswVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + flatVectorsFormat.getName() + ")";
    }
}

