/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.filtering;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.filtering.FilteringAdvancedSnippet;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRule;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationInfo;

public class FilteringRules
implements Writeable,
ToXContentObject {
    private final FilteringAdvancedSnippet advancedSnippet;
    private final List<FilteringRule> rules;
    private final FilteringValidationInfo filteringValidationInfo;
    public static final ParseField ADVANCED_SNIPPET_FIELD = new ParseField("advanced_snippet", new String[0]);
    public static final ParseField RULES_FIELD = new ParseField("rules", new String[0]);
    public static final ParseField VALIDATION_FIELD = new ParseField("validation", new String[0]);
    private static final ConstructingObjectParser<FilteringRules, Void> PARSER = new ConstructingObjectParser("connector_filtering_rules", true, args -> new Builder().setAdvancedSnippet((FilteringAdvancedSnippet)args[0]).setRules((List)args[1]).setFilteringValidationInfo((FilteringValidationInfo)args[2]).build());

    public FilteringRules(FilteringAdvancedSnippet advancedSnippet, List<FilteringRule> rules, FilteringValidationInfo filteringValidationInfo) {
        this.advancedSnippet = advancedSnippet;
        this.rules = rules;
        this.filteringValidationInfo = filteringValidationInfo;
    }

    public FilteringRules(StreamInput in) throws IOException {
        this.advancedSnippet = new FilteringAdvancedSnippet(in);
        this.rules = in.readCollectionAsList(FilteringRule::new);
        this.filteringValidationInfo = new FilteringValidationInfo(in);
    }

    public FilteringAdvancedSnippet getAdvancedSnippet() {
        return this.advancedSnippet;
    }

    public List<FilteringRule> getRules() {
        return this.rules;
    }

    public FilteringValidationInfo getFilteringValidationInfo() {
        return this.filteringValidationInfo;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ADVANCED_SNIPPET_FIELD.getPreferredName(), (ToXContent)this.advancedSnippet);
        builder.xContentList(RULES_FIELD.getPreferredName(), this.rules);
        builder.field(VALIDATION_FIELD.getPreferredName(), (ToXContent)this.filteringValidationInfo);
        builder.endObject();
        return builder;
    }

    public static FilteringRules fromXContent(XContentParser parser) throws IOException {
        return (FilteringRules)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.advancedSnippet.writeTo(out);
        out.writeCollection(this.rules);
        this.filteringValidationInfo.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringRules that = (FilteringRules)o;
        return Objects.equals(this.advancedSnippet, that.advancedSnippet) && Objects.equals(this.rules, that.rules) && Objects.equals(this.filteringValidationInfo, that.filteringValidationInfo);
    }

    public int hashCode() {
        return Objects.hash(this.advancedSnippet, this.rules, this.filteringValidationInfo);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringAdvancedSnippet.fromXContent(p), ADVANCED_SNIPPET_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringRule.fromXContent(p), RULES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringValidationInfo.fromXContent(p), VALIDATION_FIELD);
    }

    public static class Builder {
        private FilteringAdvancedSnippet advancedSnippet;
        private List<FilteringRule> rules;
        private FilteringValidationInfo filteringValidationInfo;

        public Builder setAdvancedSnippet(FilteringAdvancedSnippet advancedSnippet) {
            this.advancedSnippet = advancedSnippet;
            return this;
        }

        public Builder setRules(List<FilteringRule> rules) {
            this.rules = rules;
            return this;
        }

        public Builder setFilteringValidationInfo(FilteringValidationInfo filteringValidationInfo) {
            this.filteringValidationInfo = filteringValidationInfo;
            return this;
        }

        public FilteringRules build() {
            return new FilteringRules(this.advancedSnippet, this.rules, this.filteringValidationInfo);
        }
    }
}

