/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.content;

import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.content.KeyedBatchResponseContent;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;

public class BatchResponseContentCollection {
    private List<KeyedBatchResponseContent> batchResponses = new ArrayList<KeyedBatchResponseContent>();

    public void addBatchResponse(@Nonnull Collection<String> keys, @Nonnull BatchResponseContent content) {
        this.batchResponses.add(new KeyedBatchResponseContent(new HashSet<String>(keys), content));
    }

    private BatchResponseContent getBatchResponseContaining(@Nonnull String requestId) {
        Objects.requireNonNull(requestId);
        for (KeyedBatchResponseContent keyedResponse : this.batchResponses) {
            if (!keyedResponse.keys.contains(requestId)) continue;
            return keyedResponse.response;
        }
        return null;
    }

    @Nullable
    public Response getResponseById(@Nonnull String requestId) {
        Objects.requireNonNull(requestId);
        BatchResponseContent response = this.getBatchResponseContaining(requestId);
        return response == null ? null : response.getResponseById(requestId);
    }

    @Nullable
    public <T extends Parsable> T getResponseById(@Nonnull String requestId, @Nonnull ResponseHandler handler) {
        Objects.requireNonNull(requestId);
        BatchResponseContent response = this.getBatchResponseContaining(requestId);
        return response == null ? null : (T)response.getResponseById(requestId, handler);
    }

    @Nullable
    public <T extends Parsable> T getResponseById(@Nonnull String requestId, @Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(requestId);
        BatchResponseContent response = this.getBatchResponseContaining(requestId);
        return response == null ? null : (T)response.getResponseById(requestId, factory);
    }

    @Nullable
    public InputStream getResponseStreamById(@Nonnull String requestId) {
        BatchResponseContent response = this.getBatchResponseContaining(requestId);
        return response == null ? null : response.getResponseStreamById(requestId);
    }

    @Nonnull
    public Map<String, Integer> getResponsesStatusCodes() {
        HashMap<String, Integer> statusCodes = new HashMap<String, Integer>();
        for (KeyedBatchResponseContent keyedResponse : this.batchResponses) {
            Map<String, Integer> responseStatusCodes = keyedResponse.response.getResponsesStatusCode();
            statusCodes.putAll(responseStatusCodes);
        }
        return statusCodes;
    }
}

