"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _encode_path_params = require("../../../shared/encode_path_params");
var _routes = require("../../routes");
var _search_application_name_logic = require("./search_application_name_logic");
var _search_application_view = require("./search_application_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/search_application_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchApplicationRouter = () => {
  const searchApplicationName = decodeURIComponent((0, _reactRouterDom.useParams)().searchApplicationName);
  const searchApplicationNameLogic = (0, _search_application_name_logic.SearchApplicationNameLogic)({
    searchApplicationName
  });
  const {
    setSearchApplicationName
  } = (0, _kea.useActions)(searchApplicationNameLogic);
  (0, _react.useEffect)(() => {
    const unmountName = searchApplicationNameLogic.mount();
    return () => {
      unmountName();
    };
  }, []);
  (0, _react.useEffect)(() => {
    setSearchApplicationName(searchApplicationName);
  }, [searchApplicationName]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: _routes.SEARCH_APPLICATION_PATH,
    to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_TAB_PATH, {
      searchApplicationName,
      tabId: _routes.SearchApplicationViewTabs.DOCS_EXPLORER
    }),
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_TAB_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_application_view.SearchApplicationView, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  })));
};
exports.SearchApplicationRouter = SearchApplicationRouter;