"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestIsValid = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _helpers = require("../../../../../../lib/langchain/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requestIsValid = ({
  alertsIndexPattern,
  request,
  size
}) => (0, _helpers.requestHasRequiredAnonymizationParams)(request) && alertsIndexPattern != null && size != null && !(0, _elasticAssistantCommon.sizeIsOutOfRange)(size);
exports.requestIsValid = requestIsValid;