"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedValues = void 0;
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnonymizedValues = ({
  anonymizationFields = [],
  currentReplacements,
  field,
  getAnonymizedValue,
  rawData
}) => {
  var _rawData$field;
  const rawValues = (_rawData$field = rawData[field]) !== null && _rawData$field !== void 0 ? _rawData$field : [];
  return rawValues.reduce((acc, rawValue) => {
    const stringValue = `${rawValue}`;
    if ((0, _helpers.isAllowed)({
      anonymizationFields,
      field
    }) && (0, _helpers.isAnonymized)({
      anonymizationFields,
      field
    })) {
      const anonymizedValue = `${getAnonymizedValue({
        currentReplacements,
        rawValue: stringValue
      })}`;
      return {
        anonymizedValues: [...acc.anonymizedValues, anonymizedValue],
        replacements: {
          ...acc.replacements,
          [anonymizedValue]: stringValue
        }
      };
    } else if ((0, _helpers.isAllowed)({
      anonymizationFields,
      field
    })) {
      return {
        anonymizedValues: [...acc.anonymizedValues, stringValue],
        // no anonymization for this value
        replacements: {
          ...acc.replacements // no additional replacements
        }
      };
    } else {
      return acc;
    }
  }, {
    anonymizedValues: [],
    replacements: {}
  });
};
exports.getAnonymizedValues = getAnonymizedValues;