"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableSection = exports.AlertEventOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _utils = require("../utils");
var _ecs_description = require("../utils/ecs_description");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/security/components/alert_event_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpandableSection = ({
  title,
  children
}) => {
  const [trigger, setTrigger] = (0, _react.useState)('open');
  const onToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setTrigger(newState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `accordion-${title}`,
    forceState: trigger,
    onToggle: onToggle,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      "data-test-subj": `expandableHeader-${title}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, title)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'm',
    direction: "column",
    "data-test-subj": `expandableContent-${title}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, children));
};
exports.ExpandableSection = ExpandableSection;
const AlertEventOverview = ({
  hit
}) => {
  const {
    application: {
      getUrlForApp
    },
    fieldsMetadata
  } = (0, _use_discover_services.useDiscoverServices)();
  const timelinesURL = getUrlForApp('securitySolutionUI', {
    path: 'alerts'
  });
  const result = fieldsMetadata === null || fieldsMetadata === void 0 ? void 0 : fieldsMetadata.useFieldsMetadata({
    attributes: ['allowed_values', 'name', 'flat_name'],
    fieldNames: [_discoverUtils.fieldConstants.EVENT_CATEGORY_FIELD]
  });
  const reason = (0, _react.useMemo)(() => (0, _discoverUtils.getFieldValue)(hit, 'kibana.alert.reason'), [hit]);
  const description = (0, _react.useMemo)(() => (0, _discoverUtils.getFieldValue)(hit, 'kibana.alert.rule.description'), [hit]);
  const alertURL = (0, _react.useMemo)(() => (0, _discoverUtils.getFieldValue)(hit, 'kibana.alert.url'), [hit]);
  const eventKind = (0, _react.useMemo)(() => (0, _discoverUtils.getFieldValue)(hit, 'event.kind'), [hit]);
  const isAlert = (0, _react.useMemo)(() => eventKind === 'signal', [eventKind]);
  const eventId = (0, _react.useMemo)(() => (0, _discoverUtils.getFieldValue)(hit, '_id'), [hit]);
  const eventURL = (0, _react.useMemo)(() => (0, _utils.getSecurityTimelineRedirectUrl)({
    from: (0, _discoverUtils.getFieldValue)(hit, '@timestamp'),
    to: (0, _discoverUtils.getFieldValue)(hit, '@timestamp'),
    eventId: eventId,
    index: (0, _discoverUtils.getFieldValue)(hit, '_index'),
    baseURL: timelinesURL
  }), [hit, eventId, timelinesURL]);
  const eventCategory = (0, _react.useMemo)(() => (0, _discoverUtils.getFieldValue)(hit, 'event.category'), [hit]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": isAlert ? 'alertOverview' : 'eventOverview',
    gutterSize: "m",
    direction: "column",
    style: {
      paddingBlock: '20px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.aboutSectionTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, result !== null && result !== void 0 && result.loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    size: 's',
    isLoading: result === null || result === void 0 ? void 0 : result.loading,
    contentAriaLabel: i18n.ecsDescriptionLoadingAriaLable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "about",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, (0, _ecs_description.getEcsAllowedValueDescription)(result === null || result === void 0 ? void 0 : result.fieldsMetadata, eventCategory)))), description ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.descriptionSectionTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, description))) : null, isAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.reasonSectionTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "reason",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, reason))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exploreSecurity",
    href: isAlert && alertURL ? alertURL : eventURL,
    target: "_blank",
    iconType: "link",
    fill: true,
    "aria-label": i18n.overviewExploreButtonLabel(isAlert),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, i18n.overviewExploreButtonLabel(isAlert))));
};
exports.AlertEventOverview = AlertEventOverview;