"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSummaryColumn = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _summary_column = require("./summary_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/data_types/logs/summary_column/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getSummaryColumn = params => {
  const {
    actions,
    dataView,
    density,
    rowHeight
  } = params;
  const shouldShowFieldHandler = createGetShouldShowFieldHandler(dataView);
  return props => /*#__PURE__*/_react.default.createElement(_summary_column.SummaryColumn, (0, _extends2.default)({}, props, {
    density: density,
    onFilter: actions.addFilter,
    rowHeight: rowHeight,
    shouldShowFieldHandler: shouldShowFieldHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }));
};
exports.getSummaryColumn = getSummaryColumn;
const createGetShouldShowFieldHandler = dataView => {
  const dataViewFields = dataView.fields.getAll().map(fld => fld.name);
  return (0, _discoverUtils.getShouldShowFieldHandler)(dataViewFields, dataView, true);
};