"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPortalsRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _unifiedHistogram = require("@kbn/unified-histogram");
var _use_chart_styles = require("@kbn/unified-histogram/components/chart/hooks/use_chart_styles");
var _use_services_bootstrap = require("@kbn/unified-histogram/hooks/use_services_bootstrap");
var _context_awareness = require("../../../../context_awareness");
var _customizations = require("../../../../customizations");
var _redux = require("../../state_management/redux");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _scoped_services_provider = require("../../../../components/scoped_services_provider");
var _use_unified_histogram_runtime_state = require("./use_unified_histogram_runtime_state");
var _use_unified_histogram_common = require("./use_unified_histogram_common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/chart/chart_portals_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartPortalsRenderer = ({
  runtimeStateManager,
  children
}) => {
  const allTabIds = (0, _redux.useInternalStateSelector)(state => state.tabs.allIds);
  const currentTabId = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId);
  const chartPortalNodes = (0, _react.useRef)({});
  chartPortalNodes.current = updatePortals(chartPortalNodes.current, allTabIds);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.keys(chartPortalNodes.current).map(tabId => {
    return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
      key: tabId,
      node: chartPortalNodes.current[tabId],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(UnifiedHistogramGuard, {
      tabId: tabId,
      runtimeStateManager: runtimeStateManager,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_redux.CurrentTabProvider, {
    currentTabId: currentTabId,
    currentChartPortalNode: chartPortalNodes.current[currentTabId],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, children));
};
exports.ChartPortalsRenderer = ChartPortalsRenderer;
const updatePortals = (portals, tabsIds) => tabsIds.reduce((acc, tabId) => ({
  ...acc,
  [tabId]: portals[tabId] || (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  })
}), {});
const UnifiedHistogramGuard = ({
  tabId,
  runtimeStateManager,
  panelsToggle
}) => {
  const isSelected = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId === tabId);
  const currentTabRuntimeState = (0, _redux.selectTabRuntimeState)(runtimeStateManager, tabId);
  const currentCustomizationService = (0, _redux.useRuntimeState)(currentTabRuntimeState.customizationService$);
  const currentStateContainer = (0, _redux.useRuntimeState)(currentTabRuntimeState.stateContainer$);
  const currentScopedProfilesManager = (0, _redux.useRuntimeState)(currentTabRuntimeState.scopedProfilesManager$);
  const currentScopedEbtManager = (0, _redux.useRuntimeState)(currentTabRuntimeState.scopedEbtManager$);
  const currentDataView = (0, _redux.useRuntimeState)(currentTabRuntimeState.currentDataView$);
  const adHocDataViews = (0, _redux.useRuntimeState)(runtimeStateManager.adHocDataViews$);
  const isInitialized = (0, _react.useRef)(false);
  if (!isSelected && !isInitialized.current || !currentCustomizationService || !currentStateContainer || !currentDataView) {
    return null;
  }
  isInitialized.current = true;
  return /*#__PURE__*/_react.default.createElement(_redux.CurrentTabProvider, {
    currentTabId: tabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_customizations.DiscoverCustomizationProvider, {
    value: currentCustomizationService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: currentStateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_redux.RuntimeStateProvider, {
    currentDataView: currentDataView,
    adHocDataViews: adHocDataViews,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
    scopedProfilesManager: currentScopedProfilesManager,
    scopedEBTManager: currentScopedEbtManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ChartsWrapper, {
    stateContainer: currentStateContainer,
    panelsToggle: panelsToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }))))));
};
const ChartsWrapper = ({
  stateContainer,
  panelsToggle
}) => {
  const getChartConfigAccessor = (0, _context_awareness.useProfileAccessor)('getChartSectionConfiguration');
  const chartSectionConfig = (0, _react.useMemo)(() => getChartConfigAccessor(() => ({
    replaceDefaultChart: false
  }))(), [getChartConfigAccessor]);
  (0, _react.useEffect)(() => {
    const histogramConfig$ = (0, _redux.selectTabRuntimeState)(stateContainer.runtimeStateManager, stateContainer.getCurrentTab().id).unifiedHistogramConfig$;
    histogramConfig$.next({
      ...histogramConfig$.getValue(),
      localStorageKeyPrefix: chartSectionConfig.replaceDefaultChart ? chartSectionConfig.localStorageKeyPrefix : undefined
    });
  }, [chartSectionConfig, stateContainer]);
  return chartSectionConfig.replaceDefaultChart ? /*#__PURE__*/_react.default.createElement(CustomChartSectionWrapper, {
    stateContainer: stateContainer,
    panelsToggle: panelsToggle,
    chartSectionConfig: chartSectionConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(UnifiedHistogramWrapper, {
    stateContainer: stateContainer,
    panelsToggle: panelsToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  });
};
const UnifiedHistogramWrapper = ({
  stateContainer,
  panelsToggle
}) => {
  const {
    currentTabId,
    unifiedHistogramProps
  } = (0, _use_unified_histogram_runtime_state.useUnifiedHistogramRuntimeState)(stateContainer);
  const {
    setUnifiedHistogramApi,
    ...restProps
  } = unifiedHistogramProps;
  const unifiedHistogram = (0, _unifiedHistogram.useUnifiedHistogram)(unifiedHistogramProps);
  (0, _react.useEffect)(() => {
    if (unifiedHistogram.isInitialized) {
      setUnifiedHistogramApi(unifiedHistogram.api);
    }
  }, [setUnifiedHistogramApi, unifiedHistogram.api, unifiedHistogram.isInitialized]);
  const {
    isEsqlMode,
    renderCustomChartToggleActions
  } = (0, _use_unified_histogram_common.useUnifiedHistogramCommon)({
    currentTabId,
    layoutProps: unifiedHistogram.layoutProps,
    stateContainer,
    panelsToggle
  });
  if (!unifiedHistogram.isInitialized || !restProps.searchSessionId && !isEsqlMode) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_unifiedHistogram.UnifiedHistogramChart, (0, _extends2.default)({}, unifiedHistogram.chartProps, {
    renderCustomChartToggleActions: renderCustomChartToggleActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }));
};
const CustomChartSectionWrapper = ({
  stateContainer,
  panelsToggle,
  chartSectionConfig
}) => {
  var _chartSectionConfig$l;
  const {
    currentTabId,
    unifiedHistogramProps
  } = (0, _use_unified_histogram_runtime_state.useUnifiedHistogramRuntimeState)(stateContainer, chartSectionConfig.localStorageKeyPrefix);
  const localStorageKeyPrefix = (_chartSectionConfig$l = chartSectionConfig.localStorageKeyPrefix) !== null && _chartSectionConfig$l !== void 0 ? _chartSectionConfig$l : unifiedHistogramProps.localStorageKeyPrefix;
  const {
    setUnifiedHistogramApi,
    ...restProps
  } = unifiedHistogramProps;
  const {
    api,
    stateProps,
    requestParams,
    input$
  } = (0, _use_services_bootstrap.useServicesBootstrap)({
    ...restProps,
    initialState: unifiedHistogramProps.initialState,
    localStorageKeyPrefix
  });
  (0, _react.useEffect)(() => {
    if (api) {
      setUnifiedHistogramApi(api);
    }
  }, [api, setUnifiedHistogramApi]);
  const layoutProps = (0, _react.useMemo)(() => ({
    onTopPanelHeightChange: stateProps.onTopPanelHeightChange,
    isChartAvailable: true,
    chart: stateProps.chart,
    topPanelHeight: stateProps.topPanelHeight,
    defaultTopPanelHeight: chartSectionConfig.defaultTopPanelHeight
  }), [chartSectionConfig.defaultTopPanelHeight, stateProps.chart, stateProps.onTopPanelHeightChange, stateProps.topPanelHeight]);
  const {
    isEsqlMode,
    renderCustomChartToggleActions
  } = (0, _use_unified_histogram_common.useUnifiedHistogramCommon)({
    currentTabId,
    layoutProps,
    stateContainer,
    panelsToggle,
    localStorageKeyPrefix
  });
  const {
    chartToolbarCss,
    histogramCss
  } = (0, _use_chart_styles.useChartStyles)(!!layoutProps.chart && !layoutProps.chart.hidden);
  const hasValidSession = !!unifiedHistogramProps.searchSessionId || isEsqlMode;
  const isComponentVisible = !!chartSectionConfig.Component && !!layoutProps.chart && !layoutProps.chart.hidden;
  if (!hasValidSession) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(chartSectionConfig.Component, (0, _extends2.default)({
    histogramCss: histogramCss,
    chartToolbarCss: chartToolbarCss,
    renderToggleActions: renderCustomChartToggleActions,
    input$: input$,
    requestParams: requestParams,
    isComponentVisible: isComponentVisible
  }, unifiedHistogramProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 5
    }
  }));
};