"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Filters;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _use_dataset_quality_filters = require("../../../hooks/use_dataset_quality_filters");
var _utils = require("../../../utils");
var _filter_bar = require("./filter_bar");
var _integrations_selector = require("./integrations_selector");
var _namespaces_selector = require("./namespaces_selector");
var _qualities_selector = require("./qualities_selector");
var _selector = require("./selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/filters/filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const typesLabel = _i18n.i18n.translate('xpack.datasetQuality.types.label', {
  defaultMessage: 'Types'
});
const typesSearchPlaceholder = _i18n.i18n.translate('xpack.datasetQuality.selector.types.search.placeholder', {
  defaultMessage: 'Filter types'
});
const typesNoneMatching = _i18n.i18n.translate('xpack.datasetQuality.selector.types.noneMatching', {
  defaultMessage: 'No types found'
});
const typesNoneAvailable = _i18n.i18n.translate('xpack.datasetQuality.selector.types.noneAvailable', {
  defaultMessage: 'No types available'
});
const datePickerStyle = (0, _css.css)`
  .euiFormControlLayout {
    height: 40px;
  }
  .euiButton {
    height: 40px;
  }
`;

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Filters() {
  const {
    timeRange,
    onTimeChange,
    onRefresh,
    onRefreshChange,
    isLoading,
    integrations,
    namespaces,
    qualities,
    types,
    onIntegrationsChange,
    onNamespacesChange,
    onQualitiesChange,
    onTypesChange,
    selectedQuery,
    onQueryChange,
    isDatasetQualityAllSignalsAvailable
  } = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const {
    unifiedSearch
  } = (0, _utils.useKibanaContextForPlugin)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "datasetQualityFiltersContainer",
    gutterSize: "s",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
    query: selectedQuery,
    onQueryChange: onQueryChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_integrations_selector.IntegrationsSelector, {
    isLoading: isLoading,
    integrations: integrations,
    onIntegrationsChange: onIntegrationsChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), isDatasetQualityAllSignalsAvailable && types.length > 1 && /*#__PURE__*/_react.default.createElement(_selector.Selector, {
    dataTestSubj: "datasetQualityFilterTypeSelectable",
    label: typesLabel,
    searchPlaceholder: typesSearchPlaceholder,
    noneMatchingMessage: typesNoneMatching,
    noneAvailableMessage: typesNoneAvailable,
    options: types,
    onOptionsChange: onTypesChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_namespaces_selector.NamespacesSelector, {
    isLoading: isLoading,
    namespaces: namespaces,
    onNamespacesChange: onNamespacesChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_qualities_selector.QualitiesSelector, {
    isLoading: isLoading,
    qualities: qualities,
    onQualitiesChange: onQualitiesChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: datePickerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(unifiedSearch.ui.SearchBar, {
    appName: "datasetQuality",
    showDatePicker: true,
    showFilterBar: false,
    showQueryMenu: false,
    showQueryInput: false,
    submitButtonStyle: "iconOnly",
    displayStyle: "inPage",
    disableQueryLanguageSwitcher: true,
    query: undefined,
    dateRangeFrom: timeRange.from,
    dateRangeTo: timeRange.to,
    onQuerySubmit: payload => onTimeChange({
      start: payload.dateRange.from,
      end: payload.dateRange.to
    }),
    onRefresh: onRefresh,
    onRefreshChange: ({
      refreshInterval,
      isPaused
    }) => onRefreshChange({
      refreshInterval,
      isPaused
    }),
    refreshInterval: timeRange.refresh.value,
    isRefreshPaused: timeRange.refresh.pause,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })));
}
module.exports = exports.default;