"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardUnsavedListing = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _dashboard_backup_service = require("../services/dashboard_backup_service");
var _dashboard_content_management_service = require("../services/dashboard_content_management_service");
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
var _confirm_overlays = require("./confirm_overlays");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/dashboard_unsaved_listing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const unsavedItemStyles = {
  item: euiThemeContext => (0, _react2.css)({
    marginTop: euiThemeContext.euiTheme.size.m,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      marginTop: euiThemeContext.euiTheme.size.base
    }
  }),
  heading: euiThemeContext => (0, _react2.css)({
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      marginBottom: euiThemeContext.euiTheme.size.xs
    }
  }),
  icon: euiThemeContext => (0, _react2.css)({
    marginRight: euiThemeContext.euiTheme.size.m
  }),
  title: (0, _react2.css)({
    marginBottom: 0
  }),
  titleLoading: euiThemeContext => (0, _react2.css)({
    color: `${euiThemeContext.euiTheme.colors.subduedText} !important`
  }),
  actions: euiThemeContext => (0, _react2.css)({
    marginLeft: `calc(${euiThemeContext.euiTheme.size.l} + ${euiThemeContext.euiTheme.size.xs})`,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])]: {
      flexDirection: 'column'
    }
  })
};
const DashboardUnsavedItem = ({
  id,
  title,
  onOpenClick,
  onDiscardClick
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(unsavedItemStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    css: styles.heading,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "text",
    css: styles.icon,
    type: title ? 'dashboardApp' : 'clock',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    css: [styles.title, !title && styles.titleLoading],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, title || _dashboard_listing_strings.dashboardUnsavedListingStrings.getLoadingTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "none",
    css: styles.actions,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    color: "primary",
    disabled: !title,
    onClick: onOpenClick,
    "data-test-subj": title ? `edit-unsaved-${title.split(' ').join('-')}` : undefined,
    "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditAriaLabel(title !== null && title !== void 0 ? title : id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    color: "danger",
    disabled: !title,
    onClick: onDiscardClick,
    "data-test-subj": title ? `discard-unsaved-${title.split(' ').join('-')}` : undefined,
    "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardAriaLabel(title !== null && title !== void 0 ? title : id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardTitle()))));
};
const DashboardUnsavedListing = ({
  goToDashboard,
  unsavedDashboardIds,
  refreshUnsavedDashboards
}) => {
  const [items, setItems] = (0, _react.useState)({});
  const dashboardBackupService = (0, _react.useMemo)(() => (0, _dashboard_backup_service.getDashboardBackupService)(), []);
  const onOpen = (0, _react.useCallback)(id => {
    goToDashboard(id, 'edit');
  }, [goToDashboard]);
  const onDiscard = (0, _react.useCallback)(id => {
    (0, _confirm_overlays.confirmDiscardUnsavedChanges)(() => {
      dashboardBackupService.clearState(id);
      refreshUnsavedDashboards();
    });
  }, [dashboardBackupService, refreshUnsavedDashboards]);
  (0, _react.useEffect)(() => {
    if ((unsavedDashboardIds === null || unsavedDashboardIds === void 0 ? void 0 : unsavedDashboardIds.length) === 0) {
      return;
    }
    let canceled = false;
    const existingDashboardsWithUnsavedChanges = unsavedDashboardIds.filter(id => id !== _dashboard_backup_service.DASHBOARD_PANELS_UNSAVED_ID);
    (0, _dashboard_content_management_service.getDashboardContentManagementService)().findDashboards.findByIds(existingDashboardsWithUnsavedChanges).then(results => {
      const dashboardMap = {};
      if (canceled) {
        return;
      }
      let hasError = false;
      const newItems = results.reduce((map, result) => {
        if (result.status === 'error') {
          hasError = true;
          if (result.error.statusCode === 404) {
            // Save object not found error
            dashboardBackupService.clearState(result.id);
          }
          return map;
        }
        return {
          ...map,
          [result.id || _dashboard_backup_service.DASHBOARD_PANELS_UNSAVED_ID]: result.attributes
        };
      }, dashboardMap);
      if (hasError) {
        refreshUnsavedDashboards();
        return;
      }
      setItems(newItems);
    });
    return () => {
      canceled = true;
    };
  }, [dashboardBackupService, refreshUnsavedDashboards, unsavedDashboardIds]);
  return unsavedDashboardIds.length === 0 ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    heading: "h3",
    "data-test-subj": "unsavedDashboardsCallout",
    title: _dashboard_listing_strings.dashboardUnsavedListingStrings.getUnsavedChangesTitle(unsavedDashboardIds.length > 1),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }, unsavedDashboardIds.map(dashboardId => {
    var _items$dashboardId;
    const title = dashboardId === _dashboard_backup_service.DASHBOARD_PANELS_UNSAVED_ID ? (0, _dashboard_listing_strings.getNewDashboardTitle)() : (_items$dashboardId = items[dashboardId]) === null || _items$dashboardId === void 0 ? void 0 : _items$dashboardId.title;
    const redirectId = dashboardId === _dashboard_backup_service.DASHBOARD_PANELS_UNSAVED_ID ? undefined : dashboardId;
    return /*#__PURE__*/_react.default.createElement(DashboardUnsavedItem, {
      key: dashboardId,
      id: dashboardId,
      title: title,
      onOpenClick: () => onOpen(redirectId),
      onDiscardClick: () => onDiscard(redirectId),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 13
      }
    });
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }));
};
exports.DashboardUnsavedListing = DashboardUnsavedListing;