"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestVulnerabilitiesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _get_vendor_name = require("@kbn/cloud-security-posture/src/utils/get_vendor_name");
var _use_latest_vulnerabilities_table = require("./hooks/use_latest_vulnerabilities_table");
var _test_subjects = require("./test_subjects");
var _constants = require("./constants");
var _error_callout = require("../configurations/layout/error_callout");
var _create_detection_rule_from_vulnerability = require("./utils/create_detection_rule_from_vulnerability");
var _vulnerabilities_table_field_labels = require("./vulnerabilities_table_field_labels");
var _use_kibana = require("../../common/hooks/use_kibana");
var _data_view_context = require("../../common/contexts/data_view_context");
var _use_cloud_posture_data_table = require("../../common/hooks/use_cloud_posture_data_table");
var _use_url_query = require("../../common/hooks/use_url_query");
var _findings_flyout = require("../configurations/findings_flyout/findings_flyout");
var _cloud_security_data_table = require("../../components/cloud_security_data_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/latest_vulnerabilities_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Type Guard for checking if the given source has a vulnerability object
 * Since id might be empty with the introduction of 3rd party vulnerabilities
 * we need another to check to know if finding can be displayed in the flyout
 */
const isVulnerabilityFinding = source => {
  return 'vulnerability' in (source !== null && source !== void 0 ? source : {});
};
const getCspVulnerabilityFinding = source => {
  return isVulnerabilityFinding(source) && source;
};

/**
 * This Wrapper component renders the children if the given row is a CspVulnerabilityFinding
 * it uses React's Render Props pattern
 */
const CspVulnerabilityFindingRenderer = ({
  row,
  children
}) => {
  const finding = getCspVulnerabilityFinding(row.raw._source);
  if (!finding) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return children({
    finding
  });
};
const onOpenFlyoutCallback = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
const title = _i18n.i18n.translate('xpack.csp.findings.latestVulnerabilities.tableRowTypeLabel', {
  defaultMessage: 'Vulnerabilities'
});
const LatestVulnerabilitiesTable = ({
  groupSelectorComponent,
  height,
  nonPersistedFilters
}) => {
  const {
    cloudPostureDataTable,
    rows,
    total,
    error,
    isFetching,
    fetchNextPage
  } = (0, _use_latest_vulnerabilities_table.useLatestVulnerabilitiesTable)({
    getDefaultQuery: _constants.getDefaultQuery,
    nonPersistedFilters
  });
  const createVulnerabilityRuleFn = rowIndex => {
    var _rows$rowIndex;
    const vulnerabilityFinding = getCspVulnerabilityFinding((_rows$rowIndex = rows[rowIndex]) === null || _rows$rowIndex === void 0 ? void 0 : _rows$rowIndex.raw._source);
    if (!vulnerabilityFinding) return;
    return async http => (0, _create_detection_rule_from_vulnerability.createDetectionRuleFromVulnerabilityFinding)(http, vulnerabilityFinding);
  };
  const {
    data
  } = (0, _use_kibana.useKibana)().services;
  const {
    filterManager
  } = data.query;
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const getPersistedDefaultQuery = (0, _use_cloud_posture_data_table.usePersistedQuery)(_constants.getDefaultQuery);
  const {
    setUrlQuery
  } = (0, _use_url_query.useUrlQuery)(getPersistedDefaultQuery);
  const onAddFilter = (0, _react.useCallback)((clickedField, value, operation) => {
    const newFilters = (0, _public.generateFilters)(filterManager, clickedField, value, operation, dataView);
    filterManager.addFilters(newFilters);
    setUrlQuery({
      filters: filterManager.getFilters()
    });
  }, [dataView, filterManager, setUrlQuery]);
  const renderActionableBadge = (0, _react.useCallback)((item, i, field, object) => {
    const references = Array.isArray(object.vulnerability.reference) ? object.vulnerability.reference : [object.vulnerability.reference];
    const actions = [{
      onClick: () => onAddFilter(field, item, '+'),
      iconType: 'plusInCircle',
      ariaLabel: _i18n.i18n.translate('xpack.csp.latestVulnerabilities.table.addFilter', {
        defaultMessage: 'Add filter'
      }),
      title: _i18n.i18n.translate('xpack.csp.latestVulnerabilities.table.filterForTitle', {
        defaultMessage: 'Filter for this {value}',
        values: {
          value: field
        }
      })
    }, {
      onClick: () => onAddFilter(field, item, '-'),
      iconType: 'minusInCircle',
      ariaLabel: _i18n.i18n.translate('xpack.csp.latestVulnerabilities.table.removeFilter', {
        defaultMessage: 'Remove filter'
      }),
      title: _i18n.i18n.translate('xpack.csp.latestVulnerabilities.table.filterOutTitle', {
        defaultMessage: 'Filter out this {value}',
        values: {
          value: field
        }
      })
    }, ...(field === 'vulnerability.id' && (0, _cloudSecurityPosture.findReferenceLink)(references, item) ? [{
      onClick: () => window.open((0, _cloudSecurityPosture.findReferenceLink)(references, item), '_blank'),
      iconType: 'popout',
      ariaLabel: _i18n.i18n.translate('xpack.csp.latestVulnerabilities.table.openUrlInWindow', {
        defaultMessage: 'Open URL in window'
      }),
      title: _i18n.i18n.translate('xpack.csp.latestVulnerabilities.table.openUrlInWindow', {
        defaultMessage: 'Open URL in window'
      })
    }] : [])];
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.ActionableBadge, {
      key: `${item}-${i}`,
      item: item,
      index: i,
      actions: actions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 14
      }
    });
  }, [onAddFilter]);
  const renderMultiValueCell = (field, finding) => {
    const value = (0, _fp.get)(field, finding);
    if (!Array.isArray(value)) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 14
        }
      }, value || _findings_flyout.EMPTY_VALUE);
    }
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
      items: value,
      field: field,
      object: finding,
      renderItem: renderActionableBadge,
      firstItemRenderer: item => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 38
        }
      }, item),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 7
      }
    });
  };
  const customCellRenderer = tableRows => {
    return {
      'vulnerability.score.base': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: tableRows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 9
        }
      }, ({
        finding
      }) => {
        var _finding$vulnerabilit, _finding$vulnerabilit2, _finding$vulnerabilit3, _finding$vulnerabilit4;
        return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
          score: (_finding$vulnerabilit = finding.vulnerability) === null || _finding$vulnerabilit === void 0 ? void 0 : (_finding$vulnerabilit2 = _finding$vulnerabilit.score) === null || _finding$vulnerabilit2 === void 0 ? void 0 : _finding$vulnerabilit2.base,
          version: (_finding$vulnerabilit3 = finding.vulnerability) === null || _finding$vulnerabilit3 === void 0 ? void 0 : (_finding$vulnerabilit4 = _finding$vulnerabilit3.score) === null || _finding$vulnerabilit4 === void 0 ? void 0 : _finding$vulnerabilit4.version,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 200,
            columnNumber: 13
          }
        });
      }),
      'vulnerability.severity': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: tableRows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 9
        }
      }, ({
        finding
      }) => /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
        severity: (0, _cloudSecurityPosture.getNormalizedSeverity)(finding.vulnerability.severity),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 13
        }
      })),
      'observer.vendor': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: tableRows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 9
        }
      }, ({
        finding
      }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _get_vendor_name.getVendorName)(finding) || '-')),
      'vulnerability.id': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: tableRows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 9
        }
      }, ({
        finding
      }) => renderMultiValueCell('vulnerability.id', finding)),
      'package.name': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: rows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 9
        }
      }, ({
        finding
      }) => renderMultiValueCell('package.name', finding)),
      'package.version': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: rows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 9
        }
      }, ({
        finding
      }) => renderMultiValueCell('package.version', finding)),
      'package.fixed_version': ({
        rowIndex
      }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
        row: rows[rowIndex],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 9
        }
      }, ({
        finding
      }) => renderMultiValueCell('package.fixed_version', finding))
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_cloud_security_data_table.CloudSecurityDataTable, {
    "data-test-subj": _test_subjects.LATEST_VULNERABILITIES_TABLE,
    isLoading: isFetching,
    defaultColumns: _constants.defaultColumns,
    rows: rows,
    total: total,
    onOpenFlyoutCallback: onOpenFlyoutCallback,
    createRuleFn: createVulnerabilityRuleFn,
    cloudPostureDataTable: cloudPostureDataTable,
    loadMore: fetchNextPage,
    title: title,
    customCellRenderer: customCellRenderer,
    groupSelectorComponent: groupSelectorComponent,
    height: height,
    hasDistributionBar: false,
    columnHeaders: _vulnerabilities_table_field_labels.vulnerabilitiesTableFieldLabels,
    flyoutType: "vulnerability",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }));
};
exports.LatestVulnerabilitiesTable = LatestVulnerabilitiesTable;