"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeExternalLinkText = exports.createQueryWithMarkup = exports.FormTestComponent = void 0;
exports.waitForComponentToPaint = waitForComponentToPaint;
exports.waitForComponentToUpdate = void 0;
var _react = _interopRequireDefault(require("react"));
var _testUtils = require("react-dom/test-utils");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/common/test_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Convenience utility to remove text appended to links by EUI
 */
const removeExternalLinkText = str => str === null || str === void 0 ? void 0 : str.replace(/\(external[^)]*\)/g, '');
exports.removeExternalLinkText = removeExternalLinkText;
async function waitForComponentToPaint(wrapper, amount = 0) {
  await (0, _testUtils.act)(async () => {
    await new Promise(resolve => setTimeout(resolve, amount));
    wrapper.update();
  });
}
const waitForComponentToUpdate = async () => (0, _testUtils.act)(async () => {
  return Promise.resolve();
});
exports.waitForComponentToUpdate = waitForComponentToUpdate;
const createQueryWithMarkup = query => text => query((content, node) => {
  var _node$children;
  const hasText = el => (el === null || el === void 0 ? void 0 : el.textContent) === text;
  const childrenDontHaveText = Array.from((_node$children = node === null || node === void 0 ? void 0 : node.children) !== null && _node$children !== void 0 ? _node$children : []).every(child => !hasText(child));
  return hasText(node) && childrenDontHaveText;
});
exports.createQueryWithMarkup = createQueryWithMarkup;
// eslint-disable-next-line react/display-name
const FormTestComponent = ({
  children,
  onSubmit,
  formDefaultValue,
  schema
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    onSubmit,
    defaultValue: formDefaultValue,
    schema
  });
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => form.submit(),
    "data-test-subj": "form-test-component-submit-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, 'Submit'));
};
exports.FormTestComponent = FormTestComponent;