"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Home = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _public = require("@kbn/presentation-util-plugin/public");
var _workpad_create = require("./workpad_create");
var _workpad_templates = require("./workpad_templates");
var _my_workpads = require("./my_workpads");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/home.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadTemplates = (0, _public.withSuspense)(_workpad_templates.LazyWorkpadTemplates);
const MyWorkpads = (0, _public.withSuspense)(_my_workpads.LazyMyWorkpads);
const Home = ({
  activeTab = 'workpads'
}) => {
  const [tab, setTab] = (0, _react.useState)(activeTab);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    pageHeader: {
      pageTitle: 'Canvas',
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_workpad_create.WorkpadCreate, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 26
        }
      })],
      tabs: [{
        label: strings.getMyWorkpadsTabLabel(),
        id: 'myWorkpads',
        'data-test-subj': 'workpadListing',
        isSelected: tab === 'workpads',
        onClick: () => setTab('workpads')
      }, {
        label: strings.getWorkpadTemplatesTabLabel(),
        id: 'workpadTemplates',
        'data-test-subj': 'workpadTemplates',
        isSelected: tab === 'templates',
        onClick: () => setTab('templates')
      }]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, tab === 'workpads' ? /*#__PURE__*/_react.default.createElement(MyWorkpads, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 31
    }
  }) : /*#__PURE__*/_react.default.createElement(WorkpadTemplates, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 48
    }
  })));
};
exports.Home = Home;
const strings = {
  getMyWorkpadsTabLabel: () => _i18n.i18n.translate('xpack.canvas.home.myWorkpadsTabLabel', {
    defaultMessage: 'My workpads'
  }),
  getWorkpadTemplatesTabLabel: () => _i18n.i18n.translate('xpack.canvas.home.workpadTemplatesTabLabel', {
    defaultMessage: 'Templates',
    description: 'The label for the tab that displays a list of designed workpad templates.'
  })
};