"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLExplorerLink = MLExplorerLink;
exports.useExplorerHref = useExplorerHref;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ml-plugin/public");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _apm_date_picker = require("../../date_picker/apm_date_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/machine_learning_links/mlexplorer_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MLExplorerLink({
  jobId,
  external,
  children
}) {
  const href = useExplorerHref({
    jobId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmMLExplorerLinkLink",
    children: children,
    href: href,
    external: external,
    target: external ? '_blank' : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
}
function useExplorerHref({
  jobId
}) {
  const {
    core,
    plugins: {
      ml
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    // hardcoding a custom default of 1 hour since the default kibana timerange of 15 minutes is shorter than the ML interval
    rangeFrom = 'now-1h',
    rangeTo = 'now'
  } = urlParams;
  const href = (0, _public.useMlHref)(ml, core.http.basePath.get(), {
    page: _public.ML_PAGES.ANOMALY_EXPLORER,
    pageState: {
      jobIds: [jobId],
      timeRange: {
        from: rangeFrom,
        to: rangeTo
      },
      refreshInterval: {
        pause: true,
        value: _apm_date_picker.DEFAULT_REFRESH_INTERVAL
      }
    }
  });
  return href;
}