"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupDetails = GroupDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_group_save/group_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GroupDetails({
  isEdit,
  serviceGroup,
  onCloseModal,
  onClickNext,
  onDeleteGroup,
  isLoading,
  titleId
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const initialColor = (serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.color) || euiTheme.colors.backgroundFilledPrimary;
  const [name, setName] = (0, _react.useState)(serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.groupName);
  const [color, setColor, colorPickerErrors] = (0, _eui.useColorPickerState)(initialColor);
  const [description, setDescription] = (0, _react.useState)(serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.description);
  const isNamePristine = name === (serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.groupName);
  const isColorPristine = color === initialColor;
  (0, _react.useEffect)(() => {
    if (serviceGroup) {
      setName(serviceGroup.groupName);
      if (serviceGroup.color) {
        setColor(serviceGroup.color, {
          hex: serviceGroup.color,
          isValid: (0, _eui.isValidHex)(color)
        });
      }
      setDescription(serviceGroup.description);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [serviceGroup]); // setColor omitted: new reference each render

  const isInvalidColor = !!(colorPickerErrors !== null && colorPickerErrors !== void 0 && colorPickerErrors.length) || !(0, _eui.isValidHex)(color);
  const isInvalidName = !name;
  const isInvalid = isInvalidName || isInvalidColor;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, isEdit ? _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.edit.title', {
    defaultMessage: 'Edit group'
  }) : _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.create.title', {
    defaultMessage: 'Create group'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.name', {
      defaultMessage: 'Name'
    }),
    isInvalid: !isNamePristine && isInvalidName,
    error: !isNamePristine && isInvalidName ? _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.invalidNameError', {
      defaultMessage: 'Please provide a valid name value'
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmGroupNameInput",
    value: name || '',
    onChange: e => {
      setName(e.target.value);
    },
    isInvalid: !isNamePristine && isInvalidName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.color', {
      defaultMessage: 'Color'
    }),
    isInvalid: !isColorPristine && isInvalidColor,
    error: !isColorPristine && isInvalidColor ? _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.invalidColorError', {
      defaultMessage: 'Please provide a valid HEX color value'
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: setColor,
    color: color,
    isInvalid: !isColorPristine && isInvalidColor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.description.optional', {
      defaultMessage: 'Optional'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmGroupDetailsFieldText",
    fullWidth: true,
    value: description || '',
    onChange: e => {
      setDescription(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, isEdit && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "trash",
    iconSide: "left",
    onClick: () => {
      onDeleteGroup();
    },
    color: "danger",
    isLoading: isLoading,
    isDisabled: isLoading,
    "data-test-subj": "apmDeleteGroupButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.deleteGroup', {
    defaultMessage: 'Delete group'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginLeft: 'auto'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmGroupDetailsCancelButton",
    onClick: onCloseModal,
    isLoading: isLoading,
    isDisabled: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmGroupDetailsSelectServicesButton",
    fill: true,
    iconType: "sortRight",
    iconSide: "right",
    onClick: () => {
      var _serviceGroup$kuery;
      onClickNext({
        groupName: name || '',
        color,
        description,
        kuery: (_serviceGroup$kuery = serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery) !== null && _serviceGroup$kuery !== void 0 ? _serviceGroup$kuery : ''
      });
    },
    isLoading: isLoading,
    isDisabled: isInvalid || isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupDetailsForm.selectServices', {
    defaultMessage: 'Select services'
  }))))));
}