"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileErrorCrashesOverview = MobileErrorCrashesOverview;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _tabs = require("./tabs/tabs");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _url_helpers = require("../../../shared/links/url_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/errors_and_crashes_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MobileErrorCrashesOverview() {
  const {
    query: {
      mobileErrorTabId = _tabs.MobileErrorTabIds.ERRORS
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/errors-and-crashes');
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    onTabClick: nextTab => {
      (0, _url_helpers.push)(history, {
        query: {
          mobileErrorTabId: nextTab
        }
      });
    },
    mobileErrorTabId: mobileErrorTabId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 9
    }
  })));
}