"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartGridEmbeddableWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _dataService = require("@kbn/data-service");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _change_points_table = require("../../components/change_point_detection/change_points_table");
var _use_filters_query = require("../../hooks/use_filters_query");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_change_point_agg_request = require("../../components/change_point_detection/use_change_point_agg_request");
var _charts_grid = require("../../components/change_point_detection/charts_grid");
var _no_data_warning = require("../../components/change_point_detection/no_data_warning");
var _no_change_points_callout = require("../../components/change_point_detection/no_change_points_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/change_point_chart/embeddable_chart_component_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultSort = {
  field: 'p_value',
  direction: 'asc'
};

/**
 * Grid component wrapper for embeddable.
 *
 * @param timeRange
 * @param fn
 * @param metricField
 * @param maxSeriesToPlot
 * @param splitField
 * @param partitions
 * @constructor
 */
const ChartGridEmbeddableWrapper = ({
  viewType = _constants.CHANGE_POINT_DETECTION_VIEW_TYPE.CHARTS,
  fn,
  metricField,
  maxSeriesToPlot,
  splitField,
  partitions,
  onError,
  onRenderComplete,
  onChange,
  emptyState
}) => {
  var _results$;
  const {
    filters,
    query,
    searchBounds,
    interval
  } = (0, _use_filters_query.useFilterQueryUpdates)();
  const fieldConfig = (0, _react.useMemo)(() => {
    return {
      fn,
      metricField,
      splitField
    };
  }, [fn, metricField, splitField]);
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const combinedQuery = (0, _react.useMemo)(() => {
    var _searchBounds$min, _searchBounds$max;
    const mergedQuery = (0, _esQuery.buildEsQuery)(dataView, query, filters, uiSettings ? (0, _dataService.getEsQueryConfig)(uiSettings) : undefined);
    mergedQuery.bool.filter.push({
      range: {
        [dataView.timeFieldName]: {
          gte: (_searchBounds$min = searchBounds.min) === null || _searchBounds$min === void 0 ? void 0 : _searchBounds$min.valueOf(),
          lte: (_searchBounds$max = searchBounds.max) === null || _searchBounds$max === void 0 ? void 0 : _searchBounds$max.valueOf(),
          format: 'epoch_millis'
        }
      }
    });
    if (Array.isArray(partitions) && partitions.length > 0 && fieldConfig.splitField) {
      var _mergedQuery$bool;
      (_mergedQuery$bool = mergedQuery.bool) === null || _mergedQuery$bool === void 0 ? void 0 : _mergedQuery$bool.filter.push({
        terms: {
          [fieldConfig.splitField]: partitions
        }
      });
    }
    return mergedQuery;
  }, [dataView, fieldConfig.splitField, filters, partitions, query, searchBounds, uiSettings]);
  const requestParams = (0, _react.useMemo)(() => {
    return {
      interval
    };
  }, [interval]);
  const {
    results,
    isLoading,
    isUsingSampleData
  } = (0, _use_change_point_agg_request.useChangePointResults)(fieldConfig, requestParams, combinedQuery, 10000);
  const changePoints = (0, _react.useMemo)(() => {
    let resultChangePoints = results.sort((a, b) => {
      if (defaultSort.direction === 'asc') {
        return a[defaultSort.field] - b[defaultSort.field];
      } else {
        return b[defaultSort.field] - a[defaultSort.field];
      }
    });
    if (maxSeriesToPlot) {
      resultChangePoints = resultChangePoints.slice(0, maxSeriesToPlot);
    }
    if (onChange) {
      onChange(resultChangePoints);
    }
    return resultChangePoints;
  }, [results, maxSeriesToPlot, onChange]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        overflow: auto;
        width: 100%;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, isUsingSampleData && /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)({
      padding: `${euiTheme.size.s}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_no_change_points_callout.NoChangePointsCallout, {
    reason: (_results$ = results[0]) === null || _results$ === void 0 ? void 0 : _results$.reason,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  })), changePoints.length > 0 ? viewType === _constants.CHANGE_POINT_DETECTION_VIEW_TYPE.CHARTS ? /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    changePoints: changePoints.map(r => ({
      ...r,
      ...fieldConfig
    })),
    interval: requestParams.interval,
    onRenderComplete: onRenderComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }) : viewType === _constants.CHANGE_POINT_DETECTION_VIEW_TYPE.TABLE ? /*#__PURE__*/_react.default.createElement(_change_points_table.ChangePointsTable, {
    isLoading: false,
    annotations: changePoints,
    fieldConfig: fieldConfig,
    onRenderComplete: onRenderComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }) : null : !isLoading ? emptyState ? emptyState : /*#__PURE__*/_react.default.createElement(_no_data_warning.NoDataFoundWarning, {
    onRenderComplete: onRenderComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }) : null);
};
exports.ChartGridEmbeddableWrapper = ChartGridEmbeddableWrapper;