"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloneDynamicValueBinding = cloneDynamicValueBinding;
const cloneBindingCache_1 = require("./cloneBindingCache");
/**
 * Clones a DynamicValueBinding
 */
function cloneDynamicValueBinding(binding) {
    return {
        cache: (0, cloneBindingCache_1.cloneBindingCache)(binding.cache),
        id: binding.id,
        isSatisfiedBy: binding.isSatisfiedBy,
        moduleId: binding.moduleId,
        onActivation: binding.onActivation,
        onDeactivation: binding.onDeactivation,
        scope: binding.scope,
        serviceIdentifier: binding.serviceIdentifier,
        type: binding.type,
        // The value is not cloned
        value: binding.value,
    };
}
//# sourceMappingURL=cloneDynamicValueBinding.js.map