"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cellPopoverRendererFactory = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _copy_to_clipboard = require("../common/copy_to_clipboard");
var _filter_in = require("../../../query_bar/components/filter_in");
var _filter_out = require("../../../query_bar/components/filter_out");
var _add_to_timeline = require("../../../timeline/components/add_to_timeline");
var _field_value = require("../../utils/field_value");
var _styles = require("./styles");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/table/cell_popover_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable react/display-name */
/**
 * Used for the Indicators table cellActions column property.
 *
 * @param indicators array of {@link Indicator}
 * @param pagination information about table current page
 */
const cellPopoverRendererFactory = (indicators, pagination) => props => {
  const styles = (0, _styles.useStyles)();
  const {
    rowIndex,
    columnId
  } = props;
  const indicator = indicators[rowIndex % pagination.pageSize];
  const {
    key,
    value
  } = (0, _field_value.getIndicatorFieldAndValue)(indicator, columnId);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m",
    css: styles.popoverMaxWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_in.FilterInButtonEmpty, {
    data: indicator,
    field: key,
    "data-test-subj": _test_ids.CELL_POPOVER_TIMELINE_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_out.FilterOutButtonEmpty, {
    data: indicator,
    field: key,
    "data-test-subj": _test_ids.CELL_POPOVER_FILTER_IN_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_to_timeline.AddToTimelineButtonEmpty, {
    data: indicator,
    field: key,
    "data-test-subj": _test_ids.CELL_POPOVER_FILTER_OUT_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardButtonEmpty, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }))));
};
exports.cellPopoverRendererFactory = cellPopoverRendererFactory;