"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypesProvider = exports.FieldTypesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_ti_data_view = require("../modules/indicators/hooks/use_ti_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/containers/field_types_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldTypesContext = exports.FieldTypesContext = /*#__PURE__*/(0, _react.createContext)({});

/**
 * Exposes mapped field types for threat intel shared use
 */
const FieldTypesProvider = ({
  children
}) => {
  const {
    sourcererDataView: {
      fields = {}
    }
  } = (0, _use_ti_data_view.useTIDataView)();

  // field name to field type map to allow the cell_renderer to format dates
  const fieldTypes = (0, _react.useMemo)(() => Object.values(fields).reduce((acc, field) => {
    acc[field.name] = field.type;
    return acc;
  }, {}), [fields]);
  return /*#__PURE__*/_react.default.createElement(FieldTypesContext.Provider, {
    value: fieldTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  }, children);
};
exports.FieldTypesProvider = FieldTypesProvider;