"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadinessSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_readiness_tasks_stats = require("../hooks/use_readiness_tasks_stats");
var _use_pillar_props = require("../hooks/use_pillar_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_readiness/pages/readiness_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PIE_CHART_SIZE = 200;
const siemReadinessPieChartChartId = 'siem-readiness-pie-chart';
const PillarsPieChart = () => {
  const {
    readinessTasksStats
  } = (0, _use_readiness_tasks_stats.useReadinessTasksStats)();
  const {
    pillarPropsMap
  } = (0, _use_pillar_props.usePillarsProps)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const themeOverrides = {
    partition: {
      // responsible for creating the space in the middle for the donut shape
      emptySizeRatio: 0.7,
      // responsible for removing labels from the chart nodes
      linkLabel: {
        maximumSection: Infinity,
        maxCount: 0
      }
    }
  };
  const pieChartData = Object.entries(readinessTasksStats.pillarStatsMap).map(([pillarKey, pillarStats]) => {
    return {
      pillarKey: pillarKey,
      completedTasksCount: pillarStats.completed
    };
  });
  pieChartData.push({
    pillarKey: 'incomplete',
    completedTasksCount: readinessTasksStats.totalIncomplete
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative',
      width: PIE_CHART_SIZE
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: PIE_CHART_SIZE
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: themeOverrides,
    ariaLabelledBy: siemReadinessPieChartChartId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "pillarDonut",
    data: pieChartData,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d.completedTasksCount,
    layers: [{
      groupByRollup: d => d.pillarKey,
      nodeLabel: pillarKey => {
        if (pillarKey === 'incomplete') {
          return _i18n.i18n.translate('xpack.securitySolution.siemReadiness.incompleteTasksLabel', {
            defaultMessage: 'Incomplete'
          });
        }
        return pillarPropsMap[pillarKey].displayName;
      },
      shape: {
        fillColor: pillarKey => {
          if (pillarKey === 'incomplete') {
            return euiTheme.colors.lightShade;
          }
          return pillarPropsMap[pillarKey].color;
        }
      }
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center',
      gap: euiTheme.size.xs,
      position: 'absolute',
      inset: '25%',
      height: '50%',
      width: '50%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "eui-textCenter",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    style: {
      fontWeight: 700
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, `${readinessTasksStats.totalCompleted}/${readinessTasksStats.totalTasks}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "eui-textCenter",
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.totalTaskCompletionScore', {
    defaultMessage: 'Total task completion score'
  })))));
};
const PillarsMiniSummaryTable = () => {
  const {
    readinessTasksStats
  } = (0, _use_readiness_tasks_stats.useReadinessTasksStats)();
  const {
    pillarPropsMap
  } = (0, _use_pillar_props.usePillarsProps)();
  const legendTableData = Object.entries(readinessTasksStats.pillarStatsMap).map(([pillarKey, pillarStats]) => {
    return {
      pillarKey,
      pillarName: pillarPropsMap[pillarKey].displayName,
      ...pillarStats
    };
  });
  const columns = [{
    field: 'pillarName',
    name: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.readinessSectionColumnName', {
      defaultMessage: 'Readiness Section'
    }),
    render: (pillarName, record) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: pillarPropsMap[record.pillarKey].color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 9
      }
    }, pillarName)
  }, {
    field: 'score',
    name: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.taskScoreColumnName', {
      defaultMessage: 'Task Score'
    }),
    render: (_, record) => `${record.completed}/${record.total}`
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.pillarTaskCompletionSummaryCaption', {
      defaultMessage: 'Pillar Task Completion Summary'
    }),
    items: legendTableData,
    columns: columns,
    compressed: true
    // removes the table row borders
    ,
    css: {
      '& *': {
        borderBlock: 'none !important'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  });
};
const AboutSiemReadiness = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemReadiness.aboutSiemReadinessTitle",
    defaultMessage: "About SIEM Readiness",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemReadiness.aboutSiemReadinessDescription1",
    defaultMessage: "SIEM Readiness shows how prepared your organization is to defend against threats, built on three pillars: {visibility} (data coverage), {detection} (threat rules), and {response} (ability to act).",
    values: {
      visibility: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 27
        }
      }, 'Visibility'),
      detection: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 26
        }
      }, 'Detection'),
      response: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 25
        }
      }, 'Response')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemReadiness.aboutSiemReadinessDescription2",
    defaultMessage: "This page highlights gaps and turns them into clear tasks. Completing these tasks improves your readiness score and strengthens your security posture. Use the task list to focus on what matters\u2014like enabling logs, deploying endpoint protection, or activating detection rules. Learn more in our {docsLink}.",
    values: {
      docsLink:
      /*#__PURE__*/
      // TODO siem-readiness: update link to point to siem readiness docs when available
      _react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/index.html",
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 17
        }
      }, 'docs')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }))));
};
const ReadinessSummary = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    css: {
      padding: `${euiTheme.size.l} ${euiTheme.size.xxl}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginRight: euiTheme.size.xxl
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PillarsPieChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    css: {
      alignSelf: 'center',
      maxWidth: 330
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PillarsMiniSummaryTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(AboutSiemReadiness, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }))));
};
exports.ReadinessSummary = ReadinessSummary;