"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _objectHash = _interopRequireDefault(require("object-hash"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _missing_privileges = require("../../../common/components/missing_privileges");
var _use_missing_privileges = require("../../../common/hooks/use_missing_privileges");
var _callouts = require("../../../common/components/callouts");
var _use_get_migration_privileges = require("../logic/use_get_migration_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/pages/missing_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MissingPrivilegesCallOut = exports.MissingPrivilegesCallOut = /*#__PURE__*/_react.default.memo(() => {
  const missingDetectionsPrivileges = (0, _use_missing_privileges.useMissingPrivileges)();
  const {
    data: missingIndexPrivileges = []
  } = (0, _use_get_migration_privileges.useGetMigrationMissingPrivileges)();
  const message = (0, _react.useMemo)(() => {
    const missingPrivileges = {
      featurePrivileges: missingDetectionsPrivileges.featurePrivileges,
      indexPrivileges: [
      // include rules missing detections index privileges except of lists and items indices
      ...missingDetectionsPrivileges.indexPrivileges.filter(([indexName]) => !indexName.startsWith(_constants.DEFAULT_LISTS_INDEX) && !indexName.startsWith(_constants.DEFAULT_ITEMS_INDEX)),
      // include missing siem migrations index privileges (lookups)
      ...missingIndexPrivileges.map(({
        indexName,
        privileges
      }) => [indexName, privileges])]
    };
    const hasMissingPrivileges = missingPrivileges.indexPrivileges.length > 0 || missingPrivileges.featurePrivileges.length > 0;
    if (!hasMissingPrivileges) {
      return null;
    }
    const missingPrivilegesHash = (0, _objectHash.default)(missingPrivileges);
    return {
      type: 'primary',
      /**
       * Use privileges hash as a part of the message id.
       * We want to make sure that the user will see the
       * callout message in case his privileges change.
       * The previous click on Dismiss should not affect that.
       */
      id: `missing-siem-migrations-privileges-${missingPrivilegesHash}`,
      title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.missingPrivileges.title', {
        defaultMessage: 'Insufficient privileges'
      }),
      description: (0, _missing_privileges.missingPrivilegesCallOutBody)(missingPrivileges)
    };
  }, [missingDetectionsPrivileges, missingIndexPrivileges]);
  if (!message) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_callouts.CallOutSwitcher, {
    namespace: "siemMigrations",
    condition: true,
    message: message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
});
MissingPrivilegesCallOut.displayName = 'MissingPrivilegesCallOut';