"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNameColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table_columns/name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Name = ({
  rule,
  openMigrationRuleDetails
}) => {
  var _rule$elastic_rule$ti, _rule$elastic_rule;
  if (rule.status === _constants.SiemMigrationStatus.FAILED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "ruleName",
      color: "danger",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 7
      }
    }, rule.original_rule.title);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      openMigrationRuleDetails(rule);
    },
    "data-test-subj": "ruleName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, (_rule$elastic_rule$ti = (_rule$elastic_rule = rule.elastic_rule) === null || _rule$elastic_rule === void 0 ? void 0 : _rule$elastic_rule.title) !== null && _rule$elastic_rule$ti !== void 0 ? _rule$elastic_rule$ti : rule.original_rule.title);
};
const createNameColumn = ({
  openMigrationRuleDetails
}) => {
  return {
    field: 'elastic_rule.title',
    name: i18n.COLUMN_NAME,
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(Name, {
      rule: rule,
      openMigrationRuleDetails: openMigrationRuleDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }),
    sortable: true,
    truncateText: true,
    width: '40%',
    align: 'left'
  };
};
exports.createNameColumn = createNameColumn;