"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _validation_warning_codes = require("../../../../../../../detection_engine/rule_creation/constants/validation_warning_codes");
var _use_form_with_warnings = require("../../../../../../../common/hooks/use_form_with_warnings");
var _shared_imports = require("../../../../../../../shared_imports");
var _schema = require("../schema");
var _esql_editor = require("./esql_editor");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rule_details_flyout/tabs/translation/query_details/query_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const QueryEditor = exports.QueryEditor = /*#__PURE__*/_react.default.memo(({
  query,
  ruleName,
  onSave,
  onCancel
}) => {
  const formDefaultValue = (0, _react.useMemo)(() => {
    return {
      ruleName,
      queryBar: {
        query: {
          query,
          language: 'esql'
        }
      }
    };
  }, [query, ruleName]);
  const {
    form
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    defaultValue: formDefaultValue,
    options: {
      stripEmptyFields: false,
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES
    },
    schema: _schema.schema
  });
  const handleSaveButtonClick = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (isValid) {
      onSave(data.ruleName, data.queryBar.query.query);
    }
  }, [form, onSave]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "ruleMigrationTranslationTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    justifyContent: "flexEnd",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": i18n.CANCEL,
    iconType: "cross",
    onClick: onCancel,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": i18n.SAVE,
    "data-test-subj": "saveTranslatedRuleBtn",
    iconType: "save",
    onClick: handleSaveButtonClick,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, i18n.SAVE))), /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "ruleName",
    componentProps: {
      idAria: 'ruleMigrationTranslationRuleName',
      euiFieldProps: {
        fullWidth: true,
        'data-test-subj': 'ruleMigrationTranslationRuleName'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_esql_editor.EsqlEditor, {
    path: "queryBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }));
});
QueryEditor.displayName = 'QueryEditor';