"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionsColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _links = require("../../../../common/components/links");
var _constants = require("../../../../../common/siem_migrations/constants");
var _common = require("../../../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/dashboard_table_columns/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionName = ({
  migrationDashboard,
  installDashboard,
  shouldDisableActions: isDisabled
}) => {
  var _migrationDashboard$e;
  const onInstall = (0, _react.useCallback)(() => {
    installDashboard(migrationDashboard);
  }, [installDashboard, migrationDashboard]);

  // Failed
  if (migrationDashboard.status === _constants.SiemMigrationStatus.FAILED) {
    return null;
  }

  // Installed
  if ((_migrationDashboard$e = migrationDashboard.elastic_dashboard) !== null && _migrationDashboard$e !== void 0 && _migrationDashboard$e.id) {
    return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
      deepLinkId: _common.SecurityPageName.dashboards,
      path: migrationDashboard.elastic_dashboard.id,
      "data-test-subj": "viewDashboard",
      disabled: isDisabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, i18n.ACTIONS_VIEW_LABEL);
  }

  // Installable
  if (migrationDashboard.translation_result && (migrationDashboard.translation_result === _constants.MigrationTranslationResult.FULL || migrationDashboard.translation_result === _constants.MigrationTranslationResult.PARTIAL)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      disabled: isDisabled,
      onClick: onInstall,
      "data-test-subj": "installDashboard",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, i18n.ACTIONS_INSTALL_LABEL);
  }
};
const createActionsColumn = ({
  shouldDisableActions = false,
  installDashboard
}) => {
  return {
    field: 'elastic_dashboard',
    name: /*#__PURE__*/_react.default.createElement(_components.TableHeader, {
      title: i18n.COLUMN_ACTIONS,
      tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.dashboards.tableColumn.actionsTooltip",
        defaultMessage: "{title} {view} - go to the installed dashboard.{lineBreak} {install} - install dashboard to view and edit it.",
        values: {
          lineBreak: /*#__PURE__*/_react.default.createElement("br", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 88,
              columnNumber: 26
            }
          }),
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 90,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 91,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 92,
              columnNumber: 21
            }
          }, i18n.COLUMN_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            margin: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 93,
              columnNumber: 21
            }
          }))),
          view: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 97,
              columnNumber: 21
            }
          }, i18n.ACTIONS_VIEW_LABEL),
          install: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 98,
              columnNumber: 24
            }
          }, i18n.ACTIONS_INSTALL_LABEL)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    }),
    render: (_, dashboard) => {
      return /*#__PURE__*/_react.default.createElement(ActionName, {
        migrationDashboard: dashboard,
        installDashboard: installDashboard,
        shouldDisableActions: shouldDisableActions,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 9
        }
      });
    },
    width: '10%',
    align: 'left'
  };
};
exports.createActionsColumn = createActionsColumn;